/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootShell.execution;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.stericson.RootShell.RootShell;
import com.stericson.RootShell.execution.Shell;
import java.io.IOException;

public class Command {
    protected boolean javaCommand = false;
    protected Context context = null;
    public int totalOutput = 0;
    public int totalOutputProcessed = 0;
    ExecutionMonitor executionMonitor = null;
    Handler mHandler = null;
    protected boolean used = false;
    boolean executing = false;
    String[] command = new String[0];
    boolean finished = false;
    boolean terminated = false;
    boolean handlerEnabled = true;
    int exitCode = -1;
    int id = 0;
    int timeout = RootShell.defaultCommandTimeout;

    public Command(int id, String ... command) {
        this.command = command;
        this.id = id;
        this.createHandler(RootShell.handlerEnabled);
    }

    public Command(int id, boolean handlerEnabled, String ... command) {
        this.command = command;
        this.id = id;
        this.createHandler(handlerEnabled);
    }

    public Command(int id, int timeout, String ... command) {
        this.command = command;
        this.id = id;
        this.timeout = timeout;
        this.createHandler(RootShell.handlerEnabled);
    }

    public void commandOutput(int id, String line) {
        RootShell.log("Command", "ID: " + id + ", " + line);
        ++this.totalOutputProcessed;
    }

    public void commandTerminated(int id, String reason) {
    }

    public void commandCompleted(int id, int exitcode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void commandFinished() {
        if (!this.terminated) {
            Command command = this;
            synchronized (command) {
                if (this.mHandler != null && this.handlerEnabled) {
                    Message msg = this.mHandler.obtainMessage();
                    Bundle bundle = new Bundle();
                    bundle.putInt("action", 2);
                    msg.setData(bundle);
                    this.mHandler.sendMessage(msg);
                } else {
                    this.commandCompleted(this.id, this.exitCode);
                }
                RootShell.log("Command " + this.id + " finished.");
                this.finishCommand();
            }
        }
    }

    private void createHandler(boolean handlerEnabled) {
        this.handlerEnabled = handlerEnabled;
        if (Looper.myLooper() != null && handlerEnabled) {
            RootShell.log("CommandHandler created");
            this.mHandler = new CommandHandler();
        } else {
            RootShell.log("CommandHandler not created");
        }
    }

    public final void finish() {
        RootShell.log("Command finished at users request!");
        this.commandFinished();
    }

    protected final void finishCommand() {
        this.executing = false;
        this.finished = true;
        this.notifyAll();
    }

    public final String getCommand() {
        StringBuilder sb = new StringBuilder();
        if (this.javaCommand) {
            String filePath = this.context.getFilesDir().getPath();
            for (int i = 0; i < this.command.length; ++i) {
                if (Build.VERSION.SDK_INT > 22) {
                    sb.append("export CLASSPATH=" + filePath + "/anbuild.dex; app_process /system/bin " + this.command[i]);
                } else {
                    sb.append("dalvikvm -cp " + filePath + "/anbuild.dex com.android.internal.util.WithFramework com.stericson.RootTools.containers.RootClass " + this.command[i]);
                }
                sb.append('\n');
            }
        } else {
            for (int i = 0; i < this.command.length; ++i) {
                sb.append(this.command[i]);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public final boolean isExecuting() {
        return this.executing;
    }

    public final boolean isHandlerEnabled() {
        return this.handlerEnabled;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final int getExitCode() {
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setExitCode(int code) {
        Command command = this;
        synchronized (command) {
            this.exitCode = code;
        }
    }

    protected final void startExecution() {
        this.used = true;
        this.executionMonitor = new ExecutionMonitor(this);
        this.executionMonitor.setPriority(1);
        this.executionMonitor.start();
        this.executing = true;
    }

    public final void terminate() {
        RootShell.log("Terminating command at users request!");
        this.terminated("Terminated at users request!");
    }

    protected final void terminate(String reason) {
        try {
            Shell.closeAll();
            RootShell.log("Terminating all shells.");
            this.terminated(reason);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void terminated(String reason) {
        Command command = this;
        synchronized (command) {
            if (this.mHandler != null && this.handlerEnabled) {
                Message msg = this.mHandler.obtainMessage();
                Bundle bundle = new Bundle();
                bundle.putInt("action", 3);
                bundle.putString("text", reason);
                msg.setData(bundle);
                this.mHandler.sendMessage(msg);
            } else {
                this.commandTerminated(this.id, reason);
            }
            RootShell.log("Command " + this.id + " did not finish because it was terminated. Termination reason: " + reason);
            this.setExitCode(-1);
            this.terminated = true;
            this.finishCommand();
        }
    }

    protected final void output(int id, String line) {
        ++this.totalOutput;
        if (this.mHandler != null && this.handlerEnabled) {
            Message msg = this.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putInt("action", 1);
            bundle.putString("text", line);
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        } else {
            this.commandOutput(id, line);
        }
    }

    private class CommandHandler
    extends Handler {
        public static final String ACTION = "action";
        public static final String TEXT = "text";
        public static final int COMMAND_OUTPUT = 1;
        public static final int COMMAND_COMPLETED = 2;
        public static final int COMMAND_TERMINATED = 3;

        private CommandHandler() {
        }

        public final void handleMessage(Message msg) {
            int action = msg.getData().getInt(ACTION);
            String text = msg.getData().getString(TEXT);
            switch (action) {
                case 1: {
                    Command.this.commandOutput(Command.this.id, text);
                    break;
                }
                case 2: {
                    Command.this.commandCompleted(Command.this.id, Command.this.exitCode);
                    break;
                }
                case 3: {
                    Command.this.commandTerminated(Command.this.id, text);
                }
            }
        }
    }

    private class ExecutionMonitor
    extends Thread {
        private final Command command;

        public ExecutionMonitor(Command command2) {
            this.command = command2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.command.timeout > 0) {
                Command command = this.command;
                synchronized (command) {
                    try {
                        RootShell.log("Command " + this.command.id + " is waiting for: " + this.command.timeout);
                        this.command.wait(this.command.timeout);
                    }
                    catch (InterruptedException e) {
                        RootShell.log("Exception: " + e);
                    }
                    if (!this.command.isFinished()) {
                        RootShell.log("Timeout Exception has occurred for command: " + this.command.id + ".");
                        Command.this.terminate("Timeout Exception");
                    }
                }
            }
        }
    }
}

