/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.parselisteners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class ParsingHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingHelpers.class);
    private static ExpressionParser parser = new SpelExpressionParser();
    private static SimpleEvaluationContext context = new SimpleEvaluationContext.Builder(new PropertyAccessor[0]).build();

    ParsingHelpers() {
    }

    static MultiValueMap<String, String> getCamundaExtensionPropertiesThatStartWith(Element element, String propertyNameStartsWith) {
        LinkedMultiValueMap extensionProperties = new LinkedMultiValueMap();
        try {
            List properties = element.element("extensionElements").element("properties").elements("property");
            properties.forEach(arg_0 -> ParsingHelpers.lambda$getCamundaExtensionPropertiesThatStartWith$0(propertyNameStartsWith, (MultiValueMap)extensionProperties, arg_0));
            return extensionProperties;
        }
        catch (Exception e) {
            LOGGER.debug("Activity Duration Tracking: No Camunda Extension Element properties were found");
            return extensionProperties;
        }
    }

    static Boolean hasTrack(MultiValueMap<String, String> properties) {
        return !properties.isEmpty() && properties.containsKey((Object)"prometheus.track");
    }

    static Map evalProperty(String propertyValue) {
        Map parsedProperty = (Map)parser.parseExpression(propertyValue).getValue((EvaluationContext)context, HashMap.class);
        LOGGER.debug("Prometheus Property Value Evaluation result: {}", (Object)parsedProperty);
        return parsedProperty;
    }

    private static /* synthetic */ void lambda$getCamundaExtensionPropertiesThatStartWith$0(String propertyNameStartsWith, MultiValueMap extensionProperties, Element property) {
        String name = property.attribute("name");
        String value = property.attribute("value");
        if (property.attribute("name").startsWith(propertyNameStartsWith)) {
            extensionProperties.add((Object)name, (Object)value);
        }
    }
}

