/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.executionlisteners;

import io.digitalstate.camunda.prometheus.PrometheusHelpers;
import io.digitalstate.camunda.prometheus.collectors.SimpleHistogramMetric;
import io.digitalstate.camunda.prometheus.config.yaml.DurationTrackingConfig;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDurationExecutionListener
implements ExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDurationExecutionListener.class);
    private List<String> histogramLabelNames = Arrays.asList("engine_name", "process_definition_id", "deployment_id", "process_definition_version", "process_definition_version_tag");
    private DurationTrackingConfig metricConfig;

    public ProcessDurationExecutionListener(DurationTrackingConfig metricConfig) {
        this.metricConfig = metricConfig;
    }

    public void notify(DelegateExecution execution) throws Exception {
        String processDefinitionId = execution.getProcessDefinitionId();
        String executionId = execution.getId();
        ProcessEngine engine = (ProcessEngine)execution.getProcessEngineServices();
        String engineName = engine.getName();
        ProcessDefinition processDefinition = execution.getProcessEngineServices().getRepositoryService().getProcessDefinition(processDefinitionId);
        String processDefinitionVersion = String.valueOf(processDefinition.getVersion());
        String deploymentId = processDefinition.getDeploymentId();
        String processDefinitionVersionTag = processDefinition.getVersionTag() == null ? "" : processDefinition.getVersionTag();
        String histogramNameAggregate = this.metricConfig.getAppendProcessDefinitionIdToMetricName() ? String.join((CharSequence)"__", PrometheusHelpers.promClean(this.metricConfig.getMetricName()), PrometheusHelpers.promClean(processDefinitionId)) : PrometheusHelpers.promClean(this.metricConfig.getMetricName());
        SimpleHistogramMetric histogramMetric = new SimpleHistogramMetric(histogramNameAggregate, this.metricConfig.getHelp(), this.metricConfig.getBuckets(), this.histogramLabelNames);
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, commandContext -> {
            HistoricProcessInstanceEventEntity process = (HistoricProcessInstanceEventEntity)commandContext.getDbEntityManager().getCachedEntity(HistoricProcessInstanceEventEntity.class, executionId);
            if (process != null) {
                double durationInSeconds = (double)process.getDurationInMillis().longValue() / 1000.0;
                LOGGER.debug("Process Duration in seconds<double> calculation: {} : {} seconds", (Object)executionId, (Object)String.valueOf(durationInSeconds));
                histogramMetric.observeValue(durationInSeconds, Arrays.asList(PrometheusHelpers.promClean(engineName), PrometheusHelpers.promClean(processDefinitionId), PrometheusHelpers.promClean(deploymentId), PrometheusHelpers.promClean(processDefinitionVersion), PrometheusHelpers.promClean(processDefinitionVersionTag)));
                LOGGER.debug("Prometheus Process Duration collected: {} : {}", (Object)processDefinitionId, (Object)durationInSeconds);
            } else {
                LOGGER.error("Process Instance Entity query returned null: {}", (Object)processDefinitionId);
            }
        });
    }
}

