/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.executionlisteners;

import io.digitalstate.camunda.prometheus.PrometheusHelpers;
import io.digitalstate.camunda.prometheus.collectors.SimpleHistogramMetric;
import io.digitalstate.camunda.prometheus.config.yaml.DurationTrackingConfig;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDurationExecutionListener
implements ExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityDurationExecutionListener.class);
    private List<String> histogramLabelNames = Arrays.asList("engine_name", "element_type", "process_definition_id", "activity_id", "deployment_id", "process_definition_version", "process_definition_version_tag");
    private DurationTrackingConfig metricConfig;

    public ActivityDurationExecutionListener(DurationTrackingConfig metricConfig) {
        this.metricConfig = metricConfig;
    }

    public void notify(DelegateExecution execution) throws Exception {
        String processDefinitionId = execution.getProcessDefinitionId();
        String activityInstanceId = execution.getActivityInstanceId();
        String activityId = execution.getCurrentActivityId();
        String elementTypeName = execution.getBpmnModelElementInstance().getElementType().getTypeName();
        ProcessEngine engine = (ProcessEngine)execution.getProcessEngineServices();
        String engineName = engine.getName();
        String metricName = this.metricConfig.getMetricName();
        ProcessDefinition processDefinition = execution.getProcessEngineServices().getRepositoryService().getProcessDefinition(processDefinitionId);
        String processDefinitionVersion = String.valueOf(processDefinition.getVersion());
        String deploymentId = processDefinition.getDeploymentId();
        String processDefinitionVersionTag = processDefinition.getVersionTag() == null ? "" : processDefinition.getVersionTag();
        String histogramNameAggregate = this.metricConfig.getAppendProcessDefinitionIdToMetricName() ? String.join((CharSequence)"_", PrometheusHelpers.promClean(metricName), PrometheusHelpers.promClean(processDefinitionId)) : PrometheusHelpers.promClean(metricName);
        SimpleHistogramMetric histogramMetric = new SimpleHistogramMetric(histogramNameAggregate, this.metricConfig.getHelp(), this.metricConfig.getBuckets(), this.histogramLabelNames);
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, commandContext -> {
            HistoricActivityInstanceEventEntity activity = (HistoricActivityInstanceEventEntity)commandContext.getDbEntityManager().getCachedEntity(HistoricActivityInstanceEventEntity.class, activityInstanceId);
            if (activity != null) {
                double durationInSeconds = (double)activity.getDurationInMillis().longValue() / 1000.0;
                LOGGER.debug("Duration in seconds<double> calculation: {} : {} seconds", (Object)activityId, (Object)String.valueOf(durationInSeconds));
                histogramMetric.observeValue(durationInSeconds, Arrays.asList(PrometheusHelpers.promClean(engineName), PrometheusHelpers.promClean(elementTypeName), PrometheusHelpers.promClean(processDefinitionId), PrometheusHelpers.promClean(activityId), PrometheusHelpers.promClean(deploymentId), PrometheusHelpers.promClean(processDefinitionVersion), PrometheusHelpers.promClean(processDefinitionVersionTag)));
                LOGGER.debug("Prometheus Activity Duration collected: {} : {} : {}", new Object[]{processDefinitionId, activityInstanceId, durationInSeconds});
            } else {
                LOGGER.error("Activity Instance Entity query returned null: {} : {}", (Object)processDefinitionId, (Object)activityInstanceId);
            }
        });
    }
}

