/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors.camunda;

import io.digitalstate.camunda.prometheus.collectors.SimpleGaugeMetric;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobExecutor.class);

    public JobExecutor(final ProcessEngine processEngine, final DateTime startDate, final DateTime endDate, long startDelayMills, long frequencyMills) {
        String timerName = this.getClass().getName() + " timer";
        new Timer(timerName, true).schedule(new TimerTask(){

            @Override
            public void run() {
                JobExecutor.collectAll(processEngine, startDate, endDate);
            }
        }, startDelayMills, frequencyMills);
        LOGGER.info("Created Prometheus Metrics Collection Timer for: " + this.getClass().getName());
    }

    public static void collectJobSuccessful(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_successful", "The number of jobs successfully executed.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-successful").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Successful: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectJobFailed(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_failed", "The number of jobs that failed to execute and that were submitted for retry. Every failed attempt to execute a job is counted.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-failed").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Failed: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectJobAcquisitionAttempt(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_acquisition_attempt", "The number of job acquisition cycles performed.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-acquisition-attempt").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Acquisition Attempts: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectJobAcquiredSuccess(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_acquired_success", "The number of jobs that were acquired and successfully locked for execution.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-acquired-success").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Acquired Success: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectJobAcquiredFailure(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_acquired_failure", "The number of jobs that were acquired but could not be locked for execution due to another job executor locking/executing the jobs in parallel.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-acquired-failure").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Acquired Failure: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectJobExecutionRejected(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_execution_rejected", "The number of successfully acquired jobs submitted for execution that were rejected due to saturated execution resources. This is an indicator that the execution thread pool's job queue is full.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-execution-rejected").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Execution Rejected: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectJobLockedExclusive(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_job_locked_exclusive", "The number of exclusive jobs that are immediately locked and executed.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("job-locked-exclusive").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Job Locked Exclusive: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectAll(ProcessEngine processEngine, DateTime startDate, DateTime endDate) {
        MetricsQuery metricsQuery = processEngine.getManagementService().createMetricsQuery();
        String engineName = processEngine.getName();
        JobExecutor.collectJobSuccessful(metricsQuery, engineName, startDate, endDate);
        JobExecutor.collectJobFailed(metricsQuery, engineName, startDate, endDate);
        JobExecutor.collectJobAcquisitionAttempt(metricsQuery, engineName, startDate, endDate);
        JobExecutor.collectJobAcquiredSuccess(metricsQuery, engineName, startDate, endDate);
        JobExecutor.collectJobAcquiredFailure(metricsQuery, engineName, startDate, endDate);
        JobExecutor.collectJobExecutionRejected(metricsQuery, engineName, startDate, endDate);
        JobExecutor.collectJobLockedExclusive(metricsQuery, engineName, startDate, endDate);
    }
}

