/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors;

import io.prometheus.client.Gauge;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGaugeMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleGaugeMetric.class);
    private static ConcurrentMap<String, Gauge> gauges = new ConcurrentHashMap<String, Gauge>();
    private final String gaugeName;

    public SimpleGaugeMetric(String name, String help, List<String> labelNames) {
        gauges.computeIfAbsent(name, key -> {
            Gauge.Builder gaugeBuilder = (Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("camunda")).name(name)).help(help);
            if (labelNames != null) {
                gaugeBuilder.labelNames(labelNames.toArray(new String[0]));
            }
            Gauge gauge = (Gauge)gaugeBuilder.register();
            LOGGER.info("Prometheus SimpleGaugeMetric has been created: " + name);
            return gauge;
        });
        this.gaugeName = name;
    }

    public SimpleGaugeMetric(String name) {
        this(name, "A basic gauge", null);
    }

    public String getGaugeName() {
        return this.gaugeName;
    }

    public void increment(Number incrementValue) {
        ((Gauge)gauges.get(this.gaugeName)).inc(incrementValue.doubleValue());
    }

    public void increment() {
        ((Gauge)gauges.get(this.gaugeName)).inc();
    }

    public void increment(Number incrementValue, List<String> labels) {
        ((Gauge.Child)((Gauge)gauges.get(this.gaugeName)).labels(labels.toArray(new String[0]))).inc(incrementValue.doubleValue());
    }

    public void increment(List<String> labels) {
        ((Gauge.Child)((Gauge)gauges.get(this.gaugeName)).labels(labels.toArray(new String[0]))).inc();
    }

    public void decrement(Number decrementValue) {
        ((Gauge)gauges.get(this.gaugeName)).dec(decrementValue.doubleValue());
    }

    public void decrement() {
        ((Gauge)gauges.get(this.gaugeName)).dec();
    }

    public void decrement(Number decrementValue, List<String> labels) {
        ((Gauge.Child)((Gauge)gauges.get(this.gaugeName)).labels(labels.toArray(new String[0]))).dec(decrementValue.doubleValue());
    }

    public void decrement(List<String> labels) {
        ((Gauge.Child)((Gauge)gauges.get(this.gaugeName)).labels(labels.toArray(new String[0]))).dec();
    }

    public Double getValue(List<String> labels) {
        return ((Gauge.Child)((Gauge)gauges.get(this.gaugeName)).labels(labels.toArray(new String[0]))).get();
    }

    public void setValue(Number value, List<String> labels) {
        ((Gauge.Child)((Gauge)gauges.get(this.gaugeName)).labels(labels.toArray(new String[0]))).set(value.doubleValue());
    }
}

