/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus;

import io.digitalstate.camunda.grafana.annotations.reporters.DeploymentReporterParseListener;
import io.digitalstate.camunda.prometheus.MetricsExporter;
import io.digitalstate.camunda.prometheus.collectors.camunda.CamundaMetrics;
import io.digitalstate.camunda.prometheus.collectors.custom.CamundaCustomMetrics;
import io.digitalstate.camunda.prometheus.config.YamlConfig;
import io.digitalstate.camunda.prometheus.parselisteners.BpmnDurationTrackingParseListener;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.reporter.DbMetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.util.FileCopyUtils;

public class PrometheusProcessEnginePlugin
extends AbstractProcessEnginePlugin {
    private static YamlConfig yamlConfig;
    private String port = "9999";
    private String camundaReportingIntervalInSeconds = "900";
    private String collectorYmlFilePath;
    private String bpmnDurationParseListener;
    private String grafanaAnnotationReporting = "false";
    private String grafanaServer = "http://localhost:3000";
    private String grafanaAuthTokenPath = null;
    private static final Logger LOGGER;
    private final CollectorRegistry registry = CollectorRegistry.defaultRegistry;

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        yamlConfig = new YamlConfig(this.getCollectorYmlFilePath());
        new MetricsExporter(new Integer(this.getPort()));
        ArrayList<AbstractBpmnParseListener> parseListeners = processEngineConfiguration.getCustomPreBPMNParseListeners();
        if (parseListeners == null) {
            parseListeners = new ArrayList<AbstractBpmnParseListener>();
            processEngineConfiguration.setCustomPreBPMNParseListeners(parseListeners);
        }
        if (Boolean.parseBoolean(this.bpmnDurationParseListener)) {
            parseListeners.add(new BpmnDurationTrackingParseListener());
            LOGGER.info("Prometheus Bpmn Duration Parse Listener is Active");
        } else {
            LOGGER.info("Prometheus Bpmn Duration Parse Listener is Disabled");
        }
        if (Boolean.parseBoolean(this.getGrafanaAnnotationReporting())) {
            try {
                URI grafanaServer = new URI(this.getGrafanaServer());
                InputStream grafanaToken = new FileSystemResource(this.getGrafanaAuthTokenPath()).getInputStream();
                String grafanaAuthToken = FileCopyUtils.copyToString((Reader)new InputStreamReader(grafanaToken));
                parseListeners.add(new DeploymentReporterParseListener(grafanaServer, grafanaAuthToken));
                LOGGER.info("Grafana Deployment Annotation Reporter Parse Listener is Active");
                LOGGER.info("Grafana Annotation Server URL is set to: {}", (Object)grafanaServer.toURL().toString());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Could not start Grafana Annotation Reporting due to URI error", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Could not start Grafana Annotation Reporting due to IO error", (Throwable)e);
            }
        } else {
            LOGGER.info("Grafana Deployment Annotation Reporter Parse Listener is Disabled");
        }
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        LOGGER.info("DbMetricsReporter is being started with Interval of: " + this.getCamundaReportingIntervalInSeconds() + " seconds.");
        DbMetricsReporter metricsReporter = new DbMetricsReporter(processEngineConfiguration.getMetricsRegistry(), processEngineConfiguration.getCommandExecutorTxRequired());
        metricsReporter.setReportingIntervalInSeconds(Long.parseLong(this.getCamundaReportingIntervalInSeconds()));
        processEngineConfiguration.setDbMetricsReporter(metricsReporter);
    }

    public void postProcessEngineBuild(ProcessEngine processEngine) {
        new CamundaMetrics(yamlConfig.getSystemMetricsConfigs(), processEngine);
        new CamundaCustomMetrics(yamlConfig.getCustomMetricsConfigs(), processEngine);
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public String getCamundaReportingIntervalInSeconds() {
        return this.camundaReportingIntervalInSeconds;
    }

    public void setCamundaReportingIntervalInSeconds(String interval) {
        this.camundaReportingIntervalInSeconds = interval;
    }

    public void setCollectorYmlFilePath(String collectorYmlFilePath) {
        this.collectorYmlFilePath = collectorYmlFilePath;
    }

    public String getCollectorYmlFilePath() {
        return this.collectorYmlFilePath;
    }

    public String getBpmnDurationParseListener() {
        return this.bpmnDurationParseListener;
    }

    public void setBpmnDurationParseListener(String bpmnDurationParseListener) {
        this.bpmnDurationParseListener = bpmnDurationParseListener;
    }

    public static YamlConfig getYamlConfig() {
        return yamlConfig;
    }

    public void setGrafanaServer(String grafanaServer) {
        this.grafanaServer = grafanaServer;
    }

    public String getGrafanaServer() {
        return this.grafanaServer;
    }

    public void setGrafanaAuthTokenPath(String grafanaAuthTokenPath) {
        this.grafanaAuthTokenPath = grafanaAuthTokenPath;
    }

    public String getGrafanaAuthTokenPath() {
        return this.grafanaAuthTokenPath;
    }

    public void setGrafanaAnnotationReporting(String grafanaAnnotationReporting) {
        this.grafanaAnnotationReporting = grafanaAnnotationReporting;
    }

    public String getGrafanaAnnotationReporting() {
        return this.grafanaAnnotationReporting;
    }

    static {
        LOGGER = LoggerFactory.getLogger(PrometheusProcessEnginePlugin.class);
    }
}

