/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import cc.shinichi.library.ImagePreview;
import cc.shinichi.library.R;
import cc.shinichi.library.bean.ImageInfo;
import cc.shinichi.library.glide.FileTarget;
import cc.shinichi.library.glide.ImageLoader;
import cc.shinichi.library.glide.progress.OnProgressListener;
import cc.shinichi.library.glide.progress.ProgressManager;
import cc.shinichi.library.tool.common.HandlerUtils;
import cc.shinichi.library.tool.image.DownloadPictureUtil;
import cc.shinichi.library.tool.ui.ToastUtil;
import cc.shinichi.library.view.HackyViewPager;
import cc.shinichi.library.view.ImagePreviewAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import java.io.File;
import java.util.List;

public class ImagePreviewActivity
extends AppCompatActivity
implements Handler.Callback,
View.OnClickListener {
    public static final String TAG = "ImagePreview";
    private Context context;
    private List<ImageInfo> imageInfoList;
    private int currentItem;
    private boolean isShowDownButton;
    private boolean isShowCloseButton;
    private boolean isShowOriginButton;
    private boolean isShowIndicator;
    private ImagePreviewAdapter imagePreviewAdapter;
    private HackyViewPager viewPager;
    private TextView tv_indicator;
    private FrameLayout fm_image_show_origin_container;
    private FrameLayout fm_center_progress_container;
    private Button btn_show_origin;
    private ImageView img_download;
    private ImageView imgCloseButton;
    private View rootView;
    private View progressParentLayout;
    private boolean isUserCustomProgressView = false;
    private boolean indicatorStatus = false;
    private boolean originalStatus = false;
    private boolean downloadButtonStatus = false;
    private boolean closeButtonStatus = false;
    private String currentItemOriginPathUrl = "";
    private HandlerUtils.HandlerHolder handlerHolder;
    private int lastProgress = 0;

    public static void activityStart(Context context) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setClass(context, ImagePreviewActivity.class);
        context.startActivity(intent);
        ((Activity)context).overridePendingTransition(R.anim.fade_in, R.anim.fade_out);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sh_layout_preview);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.getWindow().addFlags(0x4000000);
        }
        this.context = this;
        this.handlerHolder = new HandlerUtils.HandlerHolder(this);
        this.imageInfoList = ImagePreview.getInstance().getImageInfoList();
        if (null == this.imageInfoList || this.imageInfoList.size() == 0) {
            this.onBackPressed();
            return;
        }
        this.currentItem = ImagePreview.getInstance().getIndex();
        this.isShowDownButton = ImagePreview.getInstance().isShowDownButton();
        this.isShowCloseButton = ImagePreview.getInstance().isShowCloseButton();
        this.isShowIndicator = ImagePreview.getInstance().isShowIndicator();
        this.currentItemOriginPathUrl = this.imageInfoList.get(this.currentItem).getOriginUrl();
        this.isShowOriginButton = ImagePreview.getInstance().isShowOriginButton(this.currentItem);
        if (this.isShowOriginButton) {
            this.checkCache(this.currentItemOriginPathUrl);
        }
        this.rootView = this.findViewById(R.id.rootView);
        this.viewPager = (HackyViewPager)this.findViewById(R.id.viewPager);
        this.tv_indicator = (TextView)this.findViewById(R.id.tv_indicator);
        this.fm_image_show_origin_container = (FrameLayout)this.findViewById(R.id.fm_image_show_origin_container);
        this.fm_center_progress_container = (FrameLayout)this.findViewById(R.id.fm_center_progress_container);
        this.fm_image_show_origin_container.setVisibility(8);
        this.fm_center_progress_container.setVisibility(8);
        int progressLayoutId = ImagePreview.getInstance().getProgressLayoutId();
        if (progressLayoutId != -1) {
            this.progressParentLayout = View.inflate((Context)this.context, (int)ImagePreview.getInstance().getProgressLayoutId(), null);
            if (this.progressParentLayout != null) {
                this.fm_center_progress_container.removeAllViews();
                this.fm_center_progress_container.addView(this.progressParentLayout);
                this.isUserCustomProgressView = true;
            } else {
                this.isUserCustomProgressView = false;
            }
        } else {
            this.isUserCustomProgressView = false;
        }
        this.btn_show_origin = (Button)this.findViewById(R.id.btn_show_origin);
        this.img_download = (ImageView)this.findViewById(R.id.img_download);
        this.imgCloseButton = (ImageView)this.findViewById(R.id.imgCloseButton);
        this.img_download.setImageResource(ImagePreview.getInstance().getDownIconResId());
        this.imgCloseButton.setImageResource(ImagePreview.getInstance().getCloseIconResId());
        this.imgCloseButton.setOnClickListener((View.OnClickListener)this);
        this.btn_show_origin.setOnClickListener((View.OnClickListener)this);
        this.img_download.setOnClickListener((View.OnClickListener)this);
        if (!this.isShowIndicator) {
            this.tv_indicator.setVisibility(8);
            this.indicatorStatus = false;
        } else if (this.imageInfoList.size() > 1) {
            this.tv_indicator.setVisibility(0);
            this.indicatorStatus = true;
        } else {
            this.tv_indicator.setVisibility(8);
            this.indicatorStatus = false;
        }
        if (ImagePreview.getInstance().getIndicatorShapeResId() > 0) {
            this.tv_indicator.setBackgroundResource(ImagePreview.getInstance().getIndicatorShapeResId());
        }
        if (this.isShowDownButton) {
            this.img_download.setVisibility(0);
            this.downloadButtonStatus = true;
        } else {
            this.img_download.setVisibility(8);
            this.downloadButtonStatus = false;
        }
        if (this.isShowCloseButton) {
            this.imgCloseButton.setVisibility(0);
            this.closeButtonStatus = true;
        } else {
            this.imgCloseButton.setVisibility(8);
            this.closeButtonStatus = false;
        }
        this.tv_indicator.setText((CharSequence)String.format(this.getString(R.string.indicator), this.currentItem + 1 + "", "" + this.imageInfoList.size()));
        this.imagePreviewAdapter = new ImagePreviewAdapter(this, this.imageInfoList);
        this.viewPager.setAdapter(this.imagePreviewAdapter);
        this.viewPager.setCurrentItem(this.currentItem);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (ImagePreview.getInstance().getBigImagePageChangeListener() != null) {
                    ImagePreview.getInstance().getBigImagePageChangeListener().onPageSelected(position);
                }
                ImagePreviewActivity.this.currentItem = position;
                ImagePreviewActivity.this.currentItemOriginPathUrl = ((ImageInfo)ImagePreviewActivity.this.imageInfoList.get(position)).getOriginUrl();
                ImagePreviewActivity.this.isShowOriginButton = ImagePreview.getInstance().isShowOriginButton(ImagePreviewActivity.this.currentItem);
                if (ImagePreviewActivity.this.isShowOriginButton) {
                    ImagePreviewActivity.this.checkCache(ImagePreviewActivity.this.currentItemOriginPathUrl);
                } else {
                    ImagePreviewActivity.this.gone();
                }
                ImagePreviewActivity.this.tv_indicator.setText((CharSequence)String.format(ImagePreviewActivity.this.getString(R.string.indicator), ImagePreviewActivity.this.currentItem + 1 + "", "" + ImagePreviewActivity.this.imageInfoList.size()));
                if (ImagePreviewActivity.this.isUserCustomProgressView) {
                    ImagePreviewActivity.this.fm_center_progress_container.setVisibility(8);
                    ImagePreviewActivity.this.lastProgress = 0;
                }
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels);
                if (ImagePreview.getInstance().getBigImagePageChangeListener() != null) {
                    ImagePreview.getInstance().getBigImagePageChangeListener().onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
            }

            public void onPageScrollStateChanged(int state) {
                super.onPageScrollStateChanged(state);
                if (ImagePreview.getInstance().getBigImagePageChangeListener() != null) {
                    ImagePreview.getInstance().getBigImagePageChangeListener().onPageScrollStateChanged(state);
                }
            }
        });
    }

    private void downloadCurrentImg() {
        DownloadPictureUtil.downloadPicture(this.context.getApplicationContext(), this.currentItemOriginPathUrl);
    }

    public void onBackPressed() {
        this.finish();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.fade_in, R.anim.fade_out);
    }

    public int convertPercentToBlackAlphaColor(float percent) {
        percent = Math.min(1.0f, Math.max(0.0f, percent));
        int intAlpha = (int)(percent * 255.0f);
        String stringAlpha = Integer.toHexString(intAlpha).toLowerCase();
        String color = "#" + (stringAlpha.length() < 2 ? "0" : "") + stringAlpha + "000000";
        return Color.parseColor((String)color);
    }

    public void setAlpha(float alpha) {
        int colorId = this.convertPercentToBlackAlphaColor(alpha);
        this.rootView.setBackgroundColor(colorId);
        if (alpha >= 1.0f) {
            if (this.indicatorStatus) {
                this.tv_indicator.setVisibility(0);
            }
            if (this.originalStatus) {
                this.fm_image_show_origin_container.setVisibility(0);
            }
            if (this.downloadButtonStatus) {
                this.img_download.setVisibility(0);
            }
            if (this.closeButtonStatus) {
                this.imgCloseButton.setVisibility(0);
            }
        } else {
            this.tv_indicator.setVisibility(8);
            this.fm_image_show_origin_container.setVisibility(8);
            this.img_download.setVisibility(8);
            this.imgCloseButton.setVisibility(8);
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 0) {
            String path = this.imageInfoList.get(this.currentItem).getOriginUrl();
            this.visible();
            if (this.isUserCustomProgressView) {
                this.gone();
            } else {
                this.btn_show_origin.setText((CharSequence)"0 %");
            }
            if (this.checkCache(path)) {
                Message message = this.handlerHolder.obtainMessage();
                Bundle bundle = new Bundle();
                bundle.putString("url", path);
                message.what = 1;
                message.obj = bundle;
                this.handlerHolder.sendMessage(message);
                return true;
            }
            this.loadOriginImage(path);
        } else if (msg.what == 1) {
            Bundle bundle = (Bundle)msg.obj;
            String url = bundle.getString("url");
            this.gone();
            if (this.currentItem == this.getRealIndexWithPath(url)) {
                if (this.isUserCustomProgressView) {
                    this.fm_center_progress_container.setVisibility(8);
                    if (ImagePreview.getInstance().getOnOriginProgressListener() != null) {
                        this.progressParentLayout.setVisibility(8);
                        ImagePreview.getInstance().getOnOriginProgressListener().finish(this.progressParentLayout);
                    }
                    this.imagePreviewAdapter.loadOrigin(this.imageInfoList.get(this.currentItem));
                } else {
                    this.imagePreviewAdapter.loadOrigin(this.imageInfoList.get(this.currentItem));
                }
            }
        } else if (msg.what == 2) {
            Bundle bundle = (Bundle)msg.obj;
            String url = bundle.getString("url");
            int progress = bundle.getInt("progress");
            if (this.currentItem == this.getRealIndexWithPath(url)) {
                if (this.isUserCustomProgressView) {
                    this.gone();
                    this.fm_center_progress_container.setVisibility(0);
                    if (ImagePreview.getInstance().getOnOriginProgressListener() != null) {
                        this.progressParentLayout.setVisibility(0);
                        ImagePreview.getInstance().getOnOriginProgressListener().progress(this.progressParentLayout, progress);
                    }
                } else {
                    this.visible();
                    this.btn_show_origin.setText((CharSequence)String.format("%s %%", String.valueOf(progress)));
                }
            }
        } else if (msg.what == 3) {
            this.btn_show_origin.setText(R.string.btn_original);
            this.fm_image_show_origin_container.setVisibility(8);
            this.originalStatus = false;
        } else if (msg.what == 4) {
            this.fm_image_show_origin_container.setVisibility(0);
            this.originalStatus = true;
        }
        return true;
    }

    private int getRealIndexWithPath(String path) {
        for (int i = 0; i < this.imageInfoList.size(); ++i) {
            if (!path.equalsIgnoreCase(this.imageInfoList.get(i).getOriginUrl())) continue;
            return i;
        }
        return 0;
    }

    private boolean checkCache(String url) {
        File cacheFile = ImageLoader.getGlideCacheFile(this.context, url);
        if (cacheFile != null && cacheFile.exists()) {
            this.gone();
            return true;
        }
        this.visible();
        return false;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.img_download) {
            if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
                    ToastUtil.getInstance()._short(this.context, this.getString(R.string.toast_deny_permission_save_failed));
                } else {
                    ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
                }
            } else {
                this.downloadCurrentImg();
            }
        } else if (i == R.id.btn_show_origin) {
            this.handlerHolder.sendEmptyMessage(0);
        } else if (i == R.id.imgCloseButton) {
            this.onBackPressed();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1) {
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    this.downloadCurrentImg();
                    continue;
                }
                ToastUtil.getInstance()._short(this.context, this.getString(R.string.toast_deny_permission_save_failed));
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        ImagePreview.getInstance().reset();
        if (this.imagePreviewAdapter != null) {
            this.imagePreviewAdapter.closePage();
        }
    }

    private void gone() {
        this.handlerHolder.sendEmptyMessage(3);
    }

    private void visible() {
        this.handlerHolder.sendEmptyMessage(4);
    }

    private void loadOriginImage(String path) {
        Glide.with((Context)this.context).downloadOnly().load(path).into((Target)new FileTarget(){

            @Override
            public void onResourceReady(@NonNull File resource, @Nullable Transition<? super File> transition) {
                super.onResourceReady(resource, transition);
            }
        });
        ProgressManager.addListener(path, new OnProgressListener(){

            @Override
            public void onProgress(String url, boolean isComplete, int percentage, long bytesRead, long totalBytes) {
                if (isComplete) {
                    Message message = ImagePreviewActivity.this.handlerHolder.obtainMessage();
                    Bundle bundle = new Bundle();
                    bundle.putString("url", url);
                    message.what = 1;
                    message.obj = bundle;
                    ImagePreviewActivity.this.handlerHolder.sendMessage(message);
                } else {
                    if (percentage == ImagePreviewActivity.this.lastProgress) {
                        return;
                    }
                    ImagePreviewActivity.this.lastProgress = percentage;
                    Message message = ImagePreviewActivity.this.handlerHolder.obtainMessage();
                    Bundle bundle = new Bundle();
                    bundle.putString("url", url);
                    bundle.putInt("progress", percentage);
                    message.what = 2;
                    message.obj = bundle;
                    ImagePreviewActivity.this.handlerHolder.sendMessage(message);
                }
            }
        });
    }
}

