/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.text.TextUtils;
import android.util.Log;
import cc.shinichi.library.tool.common.Print;
import cc.shinichi.library.tool.ui.PhoneUtil;
import java.io.IOException;

public class ImageUtil {
    private static final String TAG = "ImageUtil";

    public static int getBitmapDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
                default: {
                    degree = 0;
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap returnBm = null;
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        try {
            returnBm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        if (returnBm == null) {
            returnBm = bm;
        }
        if (bm != returnBm) {
            bm.recycle();
        }
        return returnBm;
    }

    public static int getOrientation(String imagePath) {
        boolean degree = false;
        try {
            ExifInterface exifInterface = new ExifInterface(imagePath);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int[] getWidthHeight(String imagePath) {
        int orient;
        Bitmap bitmap2;
        if (imagePath.isEmpty()) {
            return new int[]{0, 0};
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int srcWidth = options.outWidth;
        int srcHeight = options.outHeight;
        if (srcHeight == -1 || srcWidth == -1) {
            try {
                ExifInterface exifInterface = new ExifInterface(imagePath);
                srcHeight = exifInterface.getAttributeInt("ImageLength", 1);
                srcWidth = exifInterface.getAttributeInt("ImageWidth", 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((srcWidth <= 0 || srcHeight <= 0) && (bitmap2 = BitmapFactory.decodeFile((String)imagePath)) != null) {
            srcWidth = bitmap2.getWidth();
            srcHeight = bitmap2.getHeight();
            try {
                if (!bitmap2.isRecycled()) {
                    bitmap2.recycle();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((orient = ImageUtil.getOrientation(imagePath)) == 90 || orient == 270) {
            return new int[]{srcHeight, srcWidth};
        }
        return new int[]{srcWidth, srcHeight};
    }

    public static boolean isLongImage(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        float w = wh[0];
        float h = wh[1];
        float imageRatio = h / w;
        float phoneRatio = PhoneUtil.getPhoneRatio(context.getApplicationContext()) + 0.1f;
        boolean isLongImage = w > 0.0f && h > 0.0f && h > w && imageRatio >= phoneRatio;
        Print.d(TAG, "isLongImage = " + isLongImage);
        return isLongImage;
    }

    public static boolean isWideImage(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        float w = wh[0];
        float h = wh[1];
        float imageRatio = w / h;
        boolean isWideImage = w > 0.0f && h > 0.0f && w > h && imageRatio >= 2.0f;
        Print.d(TAG, "isWideImage = " + isWideImage);
        return isWideImage;
    }

    public static boolean isSmallImage(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        boolean isSmallImage = wh[0] < PhoneUtil.getPhoneWid(context.getApplicationContext());
        Print.d(TAG, "isSmallImage = " + isSmallImage);
        return isSmallImage;
    }

    public static float getLongImageMinScale(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        float imageWid = wh[0];
        float phoneWid = PhoneUtil.getPhoneWid(context.getApplicationContext());
        return phoneWid / imageWid;
    }

    public static float getLongImageMaxScale(Context context, String imagePath) {
        return ImageUtil.getLongImageMinScale(context, imagePath) * 2.0f;
    }

    public static float getWideImageDoubleScale(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        float imageHei = wh[1];
        float phoneHei = PhoneUtil.getPhoneHei(context.getApplicationContext());
        return phoneHei / imageHei;
    }

    public static float getSmallImageMinScale(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        float imageWid = wh[0];
        float phoneWid = PhoneUtil.getPhoneWid(context.getApplicationContext());
        return phoneWid / imageWid;
    }

    public static float getSmallImageMaxScale(Context context, String imagePath) {
        int[] wh = ImageUtil.getWidthHeight(imagePath);
        float imageWid = wh[0];
        float phoneWid = PhoneUtil.getPhoneWid(context.getApplicationContext());
        return phoneWid * 2.0f / imageWid;
    }

    public static Bitmap getImageBitmap(String srcPath, int degree) {
        boolean isOOM = false;
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        float be = 1.0f;
        newOpts.inSampleSize = (int)be;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        newOpts.inDither = false;
        newOpts.inPurgeable = true;
        newOpts.inInputShareable = true;
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        try {
            bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        }
        catch (OutOfMemoryError e) {
            isOOM = true;
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            Runtime.getRuntime().gc();
        }
        catch (Exception e) {
            isOOM = true;
            Runtime.getRuntime().gc();
        }
        if (isOOM) {
            try {
                bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
            }
            catch (Exception e) {
                newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
                bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
            }
        }
        if (bitmap != null) {
            if (degree == 90) {
                degree += 180;
            }
            bitmap = ImageUtil.rotateBitmapByDegree(bitmap, degree);
            int ttHeight = 1080 * bitmap.getHeight() / bitmap.getWidth();
            if (bitmap.getWidth() >= 1080) {
                bitmap = ImageUtil.zoomBitmap(bitmap, 1080, ttHeight);
            }
        }
        return bitmap;
    }

    private static Bitmap zoomBitmap(Bitmap bitmap, int width, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)width / (float)w;
        float scaleHeight = (float)height / (float)h;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
    }

    public static String getImageTypeWithMime(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        String type = options.outMimeType;
        Log.d((String)TAG, (String)("getImageTypeWithMime: type1 = " + type));
        type = TextUtils.isEmpty((CharSequence)type) ? "" : type.substring(6);
        Log.d((String)TAG, (String)("getImageTypeWithMime: type2 = " + type));
        return type;
    }

    public static boolean isPngImageWithMime(String url, String path) {
        return "png".equalsIgnoreCase(ImageUtil.getImageTypeWithMime(path)) || url.toLowerCase().endsWith("png");
    }

    public static boolean isJpegImageWithMime(String url, String path) {
        return "jpeg".equalsIgnoreCase(ImageUtil.getImageTypeWithMime(path)) || "jpg".equalsIgnoreCase(ImageUtil.getImageTypeWithMime(path)) || url.toLowerCase().endsWith("jpeg") || url.toLowerCase().endsWith("jpg");
    }

    public static boolean isBmpImageWithMime(String url, String path) {
        return "bmp".equalsIgnoreCase(ImageUtil.getImageTypeWithMime(path)) || url.toLowerCase().endsWith("bmp");
    }

    public static boolean isGifImageWithMime(String url, String path) {
        return "gif".equalsIgnoreCase(ImageUtil.getImageTypeWithMime(path)) || url.toLowerCase().endsWith("gif");
    }

    public static boolean isWebpImageWithMime(String url, String path) {
        return "webp".equalsIgnoreCase(ImageUtil.getImageTypeWithMime(path)) || url.toLowerCase().endsWith("webp");
    }

    public static boolean isStandardImage(String url, String path) {
        return ImageUtil.isJpegImageWithMime(url, path) || ImageUtil.isPngImageWithMime(url, path) || ImageUtil.isBmpImageWithMime(url, path);
    }
}

