/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.glide.progress;

import android.text.TextUtils;
import cc.shinichi.library.glide.SSLSocketClient;
import cc.shinichi.library.glide.progress.OnProgressListener;
import cc.shinichi.library.glide.progress.ProgressResponseBody;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ProgressManager {
    private static Map<String, OnProgressListener> listenersMap = Collections.synchronizedMap(new HashMap());
    private static final ProgressResponseBody.InternalProgressListener LISTENER = new ProgressResponseBody.InternalProgressListener(){

        @Override
        public void onProgress(String url, long bytesRead, long totalBytes) {
            OnProgressListener onProgressListener = ProgressManager.getProgressListener(url);
            if (onProgressListener != null) {
                int percentage = (int)((float)bytesRead * 1.0f / (float)totalBytes * 100.0f);
                boolean isComplete = percentage >= 100;
                onProgressListener.onProgress(url, isComplete, percentage, bytesRead, totalBytes);
                if (isComplete) {
                    ProgressManager.removeListener(url);
                }
            }
        }
    };

    private ProgressManager() {
    }

    public static OkHttpClient getOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                return response.newBuilder().body((ResponseBody)new ProgressResponseBody(request.url().toString(), LISTENER, response.body())).build();
            }
        }).sslSocketFactory(SSLSocketClient.getSSLSocketFactory(), SSLSocketClient.geX509tTrustManager()).hostnameVerifier(SSLSocketClient.getHostnameVerifier());
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.writeTimeout(30L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        return builder.build();
    }

    public static void addListener(String url, OnProgressListener listener) {
        if (!TextUtils.isEmpty((CharSequence)url) && listener != null) {
            listenersMap.put(url, listener);
            listener.onProgress(url, false, 1, 0L, 0L);
        }
    }

    public static void removeListener(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            listenersMap.remove(url);
        }
    }

    public static OnProgressListener getProgressListener(String url) {
        if (TextUtils.isEmpty((CharSequence)url) || listenersMap == null || listenersMap.size() == 0) {
            return null;
        }
        OnProgressListener listenerWeakReference = listenersMap.get(url);
        return listenerWeakReference;
    }
}

