/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.file;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcc/shinichi/library/tool/file/FileUtil;", "", "()V", "Companion", "library_release"})
public final class FileUtil {
    public static final Companion Companion = new Companion(null);

    public FileUtil() {
        throw (Throwable)new UnsupportedOperationException("u can't instantiate me...");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0012\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lcc/shinichi/library/tool/file/FileUtil$Companion;", "", "()V", "isExternalStorageWritable", "", "()Z", "copyFile", "resourceFile", "Ljava/io/File;", "targetPath", "", "fileName", "createFileByDeleteOldFile", "file", "filePath", "createOrExistsDir", "getAvailableCacheDir", "context", "Landroid/content/Context;", "getFileByPath", "isSpace", "s", "library_release"})
    public static final class Companion {
        @Nullable
        public final File getAvailableCacheDir(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            File file = this.isExternalStorageWritable() ? context.getExternalCacheDir() : context.getCacheDir();
            return file;
        }

        private final boolean isExternalStorageWritable() {
            String state = Environment.getExternalStorageState();
            return Intrinsics.areEqual((Object)"mounted", (Object)state);
        }

        private final File getFileByPath(String filePath) {
            File file;
            if (this.isSpace(filePath)) {
                file = null;
            } else {
                String string = filePath;
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    file = new File(it);
                } else {
                    file = null;
                }
            }
            return file;
        }

        private final boolean createOrExistsDir(File file) {
            return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
        }

        public final boolean createFileByDeleteOldFile(@Nullable String filePath) {
            return this.createFileByDeleteOldFile(this.getFileByPath(filePath));
        }

        private final boolean createFileByDeleteOldFile(File file) {
            boolean bl;
            if (file == null) {
                return false;
            }
            if (file.exists() && !file.delete()) {
                return false;
            }
            if (!this.createOrExistsDir(file.getParentFile())) {
                bl = false;
            } else {
                boolean bl2;
                try {
                    bl2 = file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }

        private final boolean isSpace(String s) {
            if (s == null) {
                return true;
            }
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public final boolean copyFile(@Nullable File resourceFile, @NotNull String targetPath, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            boolean result = false;
            if (resourceFile == null || TextUtils.isEmpty((CharSequence)targetPath)) {
                return result;
            }
            File target = new File(targetPath);
            if (target.exists()) {
                target.delete();
            } else {
                try {
                    target.mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            File targetFile = new File(targetPath + fileName);
            if (targetFile.exists()) {
                targetFile.delete();
            } else {
                try {
                    targetFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            FileChannel resourceChannel = null;
            FileChannel targetChannel = null;
            try {
                resourceChannel = new FileInputStream(resourceFile).getChannel();
                targetChannel = new FileOutputStream(targetFile).getChannel();
                resourceChannel.transferTo(0L, resourceChannel.size(), targetChannel);
                result = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return result;
            }
            catch (IOException e) {
                e.printStackTrace();
                return result;
            }
            try {
                resourceChannel.close();
                targetChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

