/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.common;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcc/shinichi/library/tool/common/NetworkUtil;", "", "()V", "TAG", "", "getActiveNetworkInfo", "Landroid/net/NetworkInfo;", "context", "Landroid/content/Context;", "isWiFi", "", "library_release"})
public final class NetworkUtil {
    private static final String TAG;
    public static final NetworkUtil INSTANCE;

    public final boolean isWiFi(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo info = this.getActiveNetworkInfo(context);
        boolean isWifi = info != null && info.isAvailable() && info.getType() == 1;
        Log.d((String)TAG, (String)("isWiFi: " + isWifi));
        return isWifi;
    }

    private final NetworkInfo getActiveNetworkInfo(Context context) {
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        return ((ConnectivityManager)object).getActiveNetworkInfo();
    }

    private NetworkUtil() {
    }

    static {
        NetworkUtil networkUtil;
        INSTANCE = networkUtil = new NetworkUtil();
        TAG = "NetworkUtil";
    }
}

