/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.common;

import android.text.TextUtils;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcc/shinichi/library/tool/common/DeviceUtil;", "", "()V", "getHarmonyVersion", "", "getHarmonyVersionCode", "", "getProp", "property", "defaultValue", "isHarmonyOs", "", "library_release"})
public final class DeviceUtil {
    public static final DeviceUtil INSTANCE;

    public final boolean isHarmonyOs() {
        boolean bl;
        try {
            Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
            Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
            bl = StringsKt.contains((CharSequence)osBrand.toString(), (CharSequence)"harmony", (boolean)true);
        }
        catch (Throwable x) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final String getHarmonyVersion() {
        return this.getProp("hw_sc.build.os.version", "");
    }

    public final int getHarmonyVersionCode() {
        int n;
        String string = this.getProp("hw_sc.build.os.apiversion", "0");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = 0;
        }
        return n;
    }

    private final String getProp(String property, String defaultValue) {
        try {
            Class<?> spClz = Class.forName("android.os.SystemProperties");
            Method method = spClz.getDeclaredMethod("get", String.class);
            Object object = method.invoke(spClz, property);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String value = (String)object;
            return TextUtils.isEmpty((CharSequence)value) ? defaultValue : value;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private DeviceUtil() {
    }

    static {
        DeviceUtil deviceUtil;
        INSTANCE = deviceUtil = new DeviceUtil();
    }
}

