/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.image;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import cc.shinichi.library.ImagePreview;
import cc.shinichi.library.R;
import cc.shinichi.library.glide.FileTarget;
import cc.shinichi.library.tool.file.FileUtil;
import cc.shinichi.library.tool.file.SingleMediaScanner;
import cc.shinichi.library.tool.image.ImageUtil;
import cc.shinichi.library.tool.ui.ToastUtil;
import cc.shinichi.library.view.listener.OnDownloadListener;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lcc/shinichi/library/tool/image/DownloadPictureUtil;", "", "()V", "downloadPicture", "", "context", "Landroid/app/Activity;", "currentItem", "", "url", "", "library_release"})
public final class DownloadPictureUtil {
    public static final DownloadPictureUtil INSTANCE;

    public final void downloadPicture(@NotNull Activity context, int currentItem, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Glide.with((Activity)context).downloadOnly().load(url).into((Target)new FileTarget(context, currentItem){
            final /* synthetic */ Activity $context;
            final /* synthetic */ int $currentItem;

            public void onLoadStarted(@Nullable Drawable placeholder) {
                super.onLoadStarted(placeholder);
                if (ImagePreview.Companion.getInstance().getDownloadListener() != null) {
                    OnDownloadListener onDownloadListener = ImagePreview.Companion.getInstance().getDownloadListener();
                    if (onDownloadListener != null) {
                        onDownloadListener.onDownloadStart(this.$context, this.$currentItem);
                    }
                } else {
                    ToastUtil.Companion.getInstance().showShort((Context)this.$context, this.$context.getString(R.string.toast_start_download));
                }
                super.onLoadStarted(placeholder);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                if (ImagePreview.Companion.getInstance().getDownloadListener() != null) {
                    OnDownloadListener onDownloadListener = ImagePreview.Companion.getInstance().getDownloadListener();
                    if (onDownloadListener != null) {
                        onDownloadListener.onDownloadFailed(this.$context, this.$currentItem);
                    }
                } else {
                    ToastUtil.Companion.getInstance().showShort((Context)this.$context, this.$context.getString(R.string.toast_save_failed));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void onResourceReady(@NotNull File resource, @Nullable Transition<? super File> transition) {
                block38: {
                    block39: {
                        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                        super.onResourceReady(resource, transition);
                        downloadFolderName = ImagePreview.Companion.getInstance().getFolderName();
                        name = String.valueOf(System.currentTimeMillis()) + "";
                        v0 = resource.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resource.absolutePath");
                        mimeType = ImageUtil.INSTANCE.getImageTypeWithMime(v0);
                        name = name + '.' + mimeType;
                        if (Build.VERSION.SDK_INT < 29) break block39;
                        resolver = this.$context.getContentResolver();
                        values = new ContentValues();
                        values.put("_display_name", name);
                        values.put("description", name);
                        values.put("mime_type", "image/" + mimeType);
                        values.put("relative_path", Environment.DIRECTORY_PICTURES + "/" + downloadFolderName + "/");
                        insertUri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                        inputStream = null;
                        os = null;
                        inputStream = new BufferedInputStream(new FileInputStream(resource.getAbsolutePath()));
                        v1 = insertUri;
                        if (v1 != null) {
                            var11_13 /* !! */  = v1;
                            var12_21 = false;
                            var13_24 = false;
                            it = var11_13 /* !! */ ;
                            $i$a$-let-DownloadPictureUtil$downloadPicture$1$onResourceReady$1 = false;
                            v2 = var23_27 = resolver.openOutputStream(it);
                        } else {
                            v2 = null;
                        }
                        v3 = os = v2;
                        if (v3 != null) {
                            var11_13 /* !! */  = v3;
                            var12_21 = false;
                            var13_24 = false;
                            it = var11_13 /* !! */ ;
                            $i$a$-let-DownloadPictureUtil$downloadPicture$1$onResourceReady$2 = false;
                            buffer = new byte[4096];
                            len = 0;
                            while (true) {
                                var18_30 = inputStream.read(buffer);
                                var19_31 = false;
                                var20_32 = false;
                                it = var18_30;
                                $i$a$-also-DownloadPictureUtil$downloadPicture$1$onResourceReady$2$1 = false;
                                len = it;
                                if (var18_30 == -1) break;
                                os.write(buffer, 0, len);
                            }
                            os.flush();
                        }
                        if (ImagePreview.Companion.getInstance().getDownloadListener() != null) {
                            v4 = ImagePreview.Companion.getInstance().getDownloadListener();
                            if (v4 != null) {
                                v4.onDownloadSuccess(this.$context, this.$currentItem);
                            }
                        } else {
                            ToastUtil.Companion.getInstance().showShort((Context)this.$context, this.$context.getString(R.string.toast_save_success, new Object[]{Environment.DIRECTORY_PICTURES + "/" + downloadFolderName}));
                        }
                        ** try [egrp 1[TRYBLOCK] [0 : 475->492)] { 
lbl-1000:
                        // 1 sources

                        {
                            v5 = os;
                            if (v5 != null) {
                                v5.close();
                            }
                        }
lbl65:
                        // 1 sources

                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break block38;
                        catch (IOException e) {
                            e.printStackTrace();
                            if (ImagePreview.Companion.getInstance().getDownloadListener() != null) {
                                v6 = ImagePreview.Companion.getInstance().getDownloadListener();
                                if (v6 != null) {
                                    v6.onDownloadFailed(this.$context, this.$currentItem);
                                }
                            } else {
                                ToastUtil.Companion.getInstance().showShort((Context)this.$context, this.$context.getString(R.string.toast_save_failed));
                            }
                            break block38;
                        }
                        finally {
                            try {
                                v7 = os;
                                if (v7 != null) {
                                    v7.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            try {
                                v8 = inputStream;
                                if (v8 != null) {
                                    v8.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    path = Environment.getExternalStorageDirectory().toString() + "/" + downloadFolderName + "/";
                    FileUtil.Companion.createFileByDeleteOldFile(path + name);
                    result = FileUtil.Companion.copyFile(resource, path, name);
                    if (result) {
                        if (ImagePreview.Companion.getInstance().getDownloadListener() != null) {
                            v9 = ImagePreview.Companion.getInstance().getDownloadListener();
                            if (v9 != null) {
                                v9.onDownloadSuccess(this.$context, this.$currentItem);
                            }
                        } else {
                            ToastUtil.Companion.getInstance().showShort((Context)this.$context, this.$context.getString(R.string.toast_save_success, new Object[]{path}));
                        }
                        new SingleMediaScanner((Context)this.$context, path + name, new SingleMediaScanner.ScanListener(){

                            public void onScanFinish() {
                            }
                        });
                    } else if (ImagePreview.Companion.getInstance().getDownloadListener() != null) {
                        v10 = ImagePreview.Companion.getInstance().getDownloadListener();
                        if (v10 != null) {
                            v10.onDownloadFailed(this.$context, this.$currentItem);
                        }
                    } else {
                        ToastUtil.Companion.getInstance().showShort((Context)this.$context, this.$context.getString(R.string.toast_save_failed));
                    }
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$currentItem = $captured_local_variable$1;
            }
        });
    }

    private DownloadPictureUtil() {
    }

    static {
        DownloadPictureUtil downloadPictureUtil;
        INSTANCE = downloadPictureUtil = new DownloadPictureUtil();
    }
}

