/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.glide;

import android.content.Context;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import cc.shinichi.library.glide.cache.DataCacheKey;
import cc.shinichi.library.glide.cache.SafeKeyGenerator;
import com.bumptech.glide.Glide;
import com.bumptech.glide.disklrucache.DiskLruCache;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.signature.EmptySignature;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/shinichi/library/glide/ImageLoader;", "", "()V", "TAG", "", "cleanDiskCache", "", "context", "Landroid/content/Context;", "clearMemory", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "getGlideCacheFile", "Ljava/io/File;", "url", "library_release"})
public final class ImageLoader {
    private static final String TAG = "ImageLoader";
    public static final ImageLoader INSTANCE;

    @Nullable
    public final File getGlideCacheFile(@NotNull Context context, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            DiskLruCache.Value value;
            Key key = (Key)new GlideUrl(url);
            EmptySignature emptySignature = EmptySignature.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)emptySignature, (String)"EmptySignature.obtain()");
            DataCacheKey dataCacheKey = new DataCacheKey(key, (Key)emptySignature);
            SafeKeyGenerator safeKeyGenerator = new SafeKeyGenerator();
            String safeKey = safeKeyGenerator.getSafeKey(dataCacheKey);
            Log.d((String)TAG, (String)("safeKey = " + safeKey));
            File file = new File(context.getCacheDir(), "image_manager_disk_cache");
            DiskLruCache diskLruCache = DiskLruCache.open((File)file, (int)1, (int)1, (long)0xFA00000);
            DiskLruCache.Value value2 = value = diskLruCache.get(safeKey);
            return value2 != null ? value2.getFile(0) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    public static final void clearMemory(@NotNull AppCompatActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Glide.get((Context)activity.getApplicationContext()).clearMemory();
    }

    @JvmStatic
    public static final void cleanDiskCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        new Thread(new Runnable(context){
            final /* synthetic */ Context $context;

            public final void run() {
                Glide.get((Context)this.$context.getApplicationContext()).clearDiskCache();
            }
            {
                this.$context = context;
            }
        }).start();
    }

    private ImageLoader() {
    }

    static {
        ImageLoader imageLoader;
        INSTANCE = imageLoader = new ImageLoader();
    }
}

