/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager.widget.PagerAdapter;
import cc.shinichi.library.ImagePreview;
import cc.shinichi.library.R;
import cc.shinichi.library.bean.ImageInfo;
import cc.shinichi.library.glide.FileTarget;
import cc.shinichi.library.glide.ImageLoader;
import cc.shinichi.library.tool.common.HttpUtil;
import cc.shinichi.library.tool.common.NetworkUtil;
import cc.shinichi.library.tool.file.FileUtil;
import cc.shinichi.library.tool.image.ImageUtil;
import cc.shinichi.library.tool.ui.PhoneUtil;
import cc.shinichi.library.tool.ui.ToastUtil;
import cc.shinichi.library.view.ImagePreviewActivity;
import cc.shinichi.library.view.helper.FingerDragHelper;
import cc.shinichi.library.view.helper.ImageSource;
import cc.shinichi.library.view.helper.SubsamplingScaleImageViewDragClose;
import cc.shinichi.library.view.listener.SimpleOnImageEventListener;
import cc.shinichi.library.view.photoview.PhotoView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImagePreviewAdapter
extends PagerAdapter {
    private static final String TAG = "ImagePreview";
    private final AppCompatActivity activity;
    private final List<ImageInfo> imageInfo;
    private HashMap<String, SubsamplingScaleImageViewDragClose> imageHashMap = new HashMap();
    private HashMap<String, PhotoView> imageGifHashMap = new HashMap();
    private String finalLoadUrl = "";

    public ImagePreviewAdapter(AppCompatActivity activity, @NonNull List<ImageInfo> imageInfo) {
        this.imageInfo = imageInfo;
        this.activity = activity;
    }

    public void closePage() {
        try {
            Map.Entry<String, Object> entry;
            if (this.imageHashMap != null && this.imageHashMap.size() > 0) {
                for (Map.Entry<String, Object> entry2 : this.imageHashMap.entrySet()) {
                    entry = entry2;
                    if (entry == null || entry.getValue() == null) continue;
                    ((SubsamplingScaleImageViewDragClose)((Object)entry.getValue())).destroyDrawingCache();
                    ((SubsamplingScaleImageViewDragClose)((Object)entry.getValue())).recycle();
                }
                this.imageHashMap.clear();
                this.imageHashMap = null;
            }
            if (this.imageGifHashMap != null && this.imageGifHashMap.size() > 0) {
                for (Map.Entry<String, Object> entry3 : this.imageGifHashMap.entrySet()) {
                    entry = entry3;
                    if (entry == null || entry.getValue() == null) continue;
                    ((PhotoView)((Object)entry.getValue())).destroyDrawingCache();
                    ((PhotoView)((Object)entry.getValue())).setImageBitmap(null);
                }
                this.imageGifHashMap.clear();
                this.imageGifHashMap = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.imageInfo.size();
    }

    public void loadOrigin(ImageInfo imageInfo) {
        String originalUrl = imageInfo.getOriginUrl();
        if (this.imageHashMap == null || this.imageGifHashMap == null) {
            this.notifyDataSetChanged();
            return;
        }
        if (this.imageHashMap.get(originalUrl) != null && this.imageGifHashMap.get(originalUrl) != null) {
            SubsamplingScaleImageViewDragClose imageView = this.imageHashMap.get(imageInfo.getOriginUrl());
            PhotoView imageGif = this.imageGifHashMap.get(imageInfo.getOriginUrl());
            File cacheFile = ImageLoader.getGlideCacheFile((Context)this.activity, imageInfo.getOriginUrl());
            if (cacheFile != null && cacheFile.exists()) {
                boolean isCacheIsGif = ImageUtil.isGifImageWithMime(originalUrl, cacheFile.getAbsolutePath());
                if (isCacheIsGif) {
                    if (imageView != null) {
                        imageView.setVisibility(8);
                    }
                    if (imageGif != null) {
                        imageGif.setVisibility(0);
                        Glide.with((FragmentActivity)this.activity).asGif().load(cacheFile).apply(((RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.RESOURCE)).error(ImagePreview.getInstance().getErrorPlaceHolder())).into((ImageView)imageGif);
                    }
                } else {
                    if (imageGif != null) {
                        imageGif.setVisibility(8);
                    }
                    if (imageView != null) {
                        imageView.setVisibility(0);
                        String thumbnailUrl = imageInfo.getThumbnailUrl();
                        File smallCacheFile = ImageLoader.getGlideCacheFile((Context)this.activity, thumbnailUrl);
                        ImageSource small = null;
                        if (smallCacheFile != null && smallCacheFile.exists()) {
                            String smallImagePath = smallCacheFile.getAbsolutePath();
                            small = ImageSource.bitmap(ImageUtil.getImageBitmap(smallImagePath, ImageUtil.getBitmapDegree(smallImagePath)));
                            int widSmall = ImageUtil.getWidthHeight(smallImagePath)[0];
                            int heiSmall = ImageUtil.getWidthHeight(smallImagePath)[1];
                            if (ImageUtil.isBmpImageWithMime(originalUrl, cacheFile.getAbsolutePath())) {
                                small.tilingDisabled();
                            }
                            small.dimensions(widSmall, heiSmall);
                        }
                        String imagePath = cacheFile.getAbsolutePath();
                        ImageSource origin = ImageSource.uri(imagePath);
                        int widOrigin = ImageUtil.getWidthHeight(imagePath)[0];
                        int heiOrigin = ImageUtil.getWidthHeight(imagePath)[1];
                        if (ImageUtil.isBmpImageWithMime(originalUrl, cacheFile.getAbsolutePath())) {
                            origin.tilingDisabled();
                        }
                        origin.dimensions(widOrigin, heiOrigin);
                        this.setImageSpec(imagePath, imageView);
                        imageView.setOrientation(-1);
                        imageView.setImage(origin, small);
                    }
                }
            } else {
                this.notifyDataSetChanged();
            }
        } else {
            this.notifyDataSetChanged();
        }
    }

    @SuppressLint(value={"CheckResult"})
    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, final int position) {
        if (this.activity == null) {
            return container;
        }
        View convertView = View.inflate((Context)this.activity, (int)R.layout.sh_item_photoview, null);
        final ProgressBar progressBar = (ProgressBar)convertView.findViewById(R.id.progress_view);
        FingerDragHelper fingerDragHelper = (FingerDragHelper)convertView.findViewById(R.id.fingerDragHelper);
        final SubsamplingScaleImageViewDragClose imageView = (SubsamplingScaleImageViewDragClose)convertView.findViewById(R.id.photo_view);
        final PhotoView imageGif = (PhotoView)convertView.findViewById(R.id.gif_view);
        ImageInfo info = this.imageInfo.get(position);
        final String originPathUrl = info.getOriginUrl();
        String thumbPathUrl = info.getThumbnailUrl();
        imageView.setMinimumScaleType(1);
        imageView.setDoubleTapZoomStyle(2);
        imageView.setDoubleTapZoomDuration(ImagePreview.getInstance().getZoomTransitionDuration());
        imageView.setMinScale(ImagePreview.getInstance().getMinScale());
        imageView.setMaxScale(ImagePreview.getInstance().getMaxScale());
        imageView.setDoubleTapZoomScale(ImagePreview.getInstance().getMediumScale());
        imageGif.setZoomTransitionDuration(ImagePreview.getInstance().getZoomTransitionDuration());
        imageGif.setMinimumScale(ImagePreview.getInstance().getMinScale());
        imageGif.setMaximumScale(ImagePreview.getInstance().getMaxScale());
        imageGif.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImagePreview.getInstance().isEnableClickClose()) {
                    ImagePreviewAdapter.this.activity.finish();
                }
                if (ImagePreview.getInstance().getBigImageClickListener() != null) {
                    ImagePreview.getInstance().getBigImageClickListener().onClick((Activity)ImagePreviewAdapter.this.activity, v, position);
                }
            }
        });
        imageGif.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImagePreview.getInstance().isEnableClickClose()) {
                    ImagePreviewAdapter.this.activity.finish();
                }
                if (ImagePreview.getInstance().getBigImageClickListener() != null) {
                    ImagePreview.getInstance().getBigImageClickListener().onClick((Activity)ImagePreviewAdapter.this.activity, v, position);
                }
            }
        });
        imageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ImagePreview.getInstance().getBigImageLongClickListener() != null) {
                    return ImagePreview.getInstance().getBigImageLongClickListener().onLongClick((Activity)ImagePreviewAdapter.this.activity, v, position);
                }
                return false;
            }
        });
        imageGif.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ImagePreview.getInstance().getBigImageLongClickListener() != null) {
                    return ImagePreview.getInstance().getBigImageLongClickListener().onLongClick((Activity)ImagePreviewAdapter.this.activity, v, position);
                }
                return false;
            }
        });
        if (this.activity instanceof ImagePreviewActivity) {
            ((ImagePreviewActivity)this.activity).setAlpha(1.0f);
        }
        if (ImagePreview.getInstance().isEnableDragClose()) {
            fingerDragHelper.setOnAlphaChangeListener(new FingerDragHelper.onAlphaChangedListener(){

                @Override
                public void onTranslationYChanged(MotionEvent event, float translationY) {
                    float yAbs = Math.abs(translationY);
                    float percent = yAbs / (float)PhoneUtil.getPhoneHei(ImagePreviewAdapter.this.activity.getApplicationContext());
                    float number = 1.0f - percent;
                    if (ImagePreviewAdapter.this.activity instanceof ImagePreviewActivity) {
                        ((ImagePreviewActivity)ImagePreviewAdapter.this.activity).setAlpha(number);
                    }
                    if (imageGif.getVisibility() == 0) {
                        imageGif.setScaleY(number);
                        imageGif.setScaleX(number);
                    }
                    if (imageView.getVisibility() == 0) {
                        imageView.setScaleY(number);
                        imageView.setScaleX(number);
                    }
                }
            });
        }
        this.imageGifHashMap.remove(originPathUrl);
        this.imageGifHashMap.put(originPathUrl, imageGif);
        this.imageHashMap.remove(originPathUrl);
        this.imageHashMap.put(originPathUrl, imageView);
        ImagePreview.LoadStrategy loadStrategy = ImagePreview.getInstance().getLoadStrategy();
        if (loadStrategy == ImagePreview.LoadStrategy.Default) {
            this.finalLoadUrl = thumbPathUrl;
        } else if (loadStrategy == ImagePreview.LoadStrategy.AlwaysOrigin) {
            this.finalLoadUrl = originPathUrl;
        } else if (loadStrategy == ImagePreview.LoadStrategy.AlwaysThumb) {
            this.finalLoadUrl = thumbPathUrl;
        } else if (loadStrategy == ImagePreview.LoadStrategy.NetworkAuto) {
            this.finalLoadUrl = NetworkUtil.isWiFi((Context)this.activity) ? originPathUrl : thumbPathUrl;
        }
        final String url = this.finalLoadUrl = this.finalLoadUrl.trim();
        progressBar.setVisibility(0);
        File cacheFile = ImageLoader.getGlideCacheFile((Context)this.activity, originPathUrl);
        if (cacheFile != null && cacheFile.exists()) {
            String imagePath = cacheFile.getAbsolutePath();
            boolean isStandardImage = ImageUtil.isStandardImage(originPathUrl, imagePath);
            if (isStandardImage) {
                this.loadImageStandard(imagePath, imageView, (ImageView)imageGif, progressBar);
            } else {
                this.loadImageSpec(url, imagePath, imageView, (ImageView)imageGif, progressBar);
            }
        } else {
            Glide.with((FragmentActivity)this.activity).downloadOnly().load(url).addListener((RequestListener)new RequestListener<File>(){

                public boolean onLoadFailed(final @Nullable GlideException e, Object model, Target<File> target, boolean isFirstResource) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String fileFullName = String.valueOf(System.currentTimeMillis());
                            String saveDir = FileUtil.getAvailableCacheDir((Context)ImagePreviewAdapter.this.activity).getAbsolutePath() + File.separator + "image/";
                            final File downloadFile = HttpUtil.downloadFile(url, fileFullName, saveDir);
                            new Handler(Looper.getMainLooper()).post(new Runnable(){

                                @Override
                                public void run() {
                                    if (downloadFile != null && downloadFile.exists() && downloadFile.length() > 0L) {
                                        ImagePreviewAdapter.this.loadSuccess(originPathUrl, downloadFile, imageView, (ImageView)imageGif, progressBar);
                                    } else {
                                        ImagePreviewAdapter.this.loadFailed(imageView, (ImageView)imageGif, progressBar, e);
                                    }
                                }
                            });
                        }
                    }).start();
                    return true;
                }

                public boolean onResourceReady(File resource, Object model, Target<File> target, DataSource dataSource, boolean isFirstResource) {
                    ImagePreviewAdapter.this.loadSuccess(url, resource, imageView, (ImageView)imageGif, progressBar);
                    return true;
                }
            }).into((Target)new FileTarget(){

                @Override
                public void onLoadStarted(@Nullable Drawable placeholder) {
                    super.onLoadStarted(placeholder);
                }
            });
        }
        container.addView(convertView);
        return convertView;
    }

    public void setPrimaryItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        super.setPrimaryItem(container, position, object);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    private void loadFailed(SubsamplingScaleImageViewDragClose imageView, ImageView imageGif, ProgressBar progressBar, GlideException e) {
        progressBar.setVisibility(8);
        imageGif.setVisibility(8);
        imageView.setVisibility(0);
        imageView.setZoomEnabled(false);
        imageView.setImage(ImageSource.resource(ImagePreview.getInstance().getErrorPlaceHolder()));
        if (ImagePreview.getInstance().isShowErrorToast()) {
            String errorMsg = this.activity.getString(R.string.toast_load_failed);
            if (e != null) {
                errorMsg = errorMsg.concat(":\n").concat(e.getMessage());
            }
            if (errorMsg.length() > 200) {
                errorMsg = errorMsg.substring(0, 199);
            }
            ToastUtil.getInstance()._short(this.activity.getApplicationContext(), errorMsg);
        }
    }

    private void loadSuccess(String imageUrl, File resource, SubsamplingScaleImageViewDragClose imageView, ImageView imageGif, ProgressBar progressBar) {
        String imagePath = resource.getAbsolutePath();
        boolean isStandardImage = ImageUtil.isStandardImage(imageUrl, imagePath);
        if (isStandardImage) {
            this.loadImageStandard(imagePath, imageView, imageGif, progressBar);
        } else {
            this.loadImageSpec(imageUrl, imagePath, imageView, imageGif, progressBar);
        }
    }

    private void setImageSpec(String imagePath, SubsamplingScaleImageViewDragClose imageView) {
        boolean isLongImage = ImageUtil.isLongImage((Context)this.activity, imagePath);
        if (isLongImage) {
            imageView.setMinimumScaleType(4);
            imageView.setMinScale(ImageUtil.getLongImageMinScale((Context)this.activity, imagePath));
            imageView.setMaxScale(ImageUtil.getLongImageMaxScale((Context)this.activity, imagePath));
            imageView.setDoubleTapZoomScale(ImageUtil.getLongImageMaxScale((Context)this.activity, imagePath));
        } else {
            boolean isWideImage = ImageUtil.isWideImage((Context)this.activity, imagePath);
            boolean isSmallImage = ImageUtil.isSmallImage((Context)this.activity, imagePath);
            if (isWideImage) {
                imageView.setMinimumScaleType(1);
                imageView.setMinScale(ImagePreview.getInstance().getMinScale());
                imageView.setMaxScale(ImagePreview.getInstance().getMaxScale());
                imageView.setDoubleTapZoomScale(ImageUtil.getWideImageDoubleScale((Context)this.activity, imagePath));
            } else if (isSmallImage) {
                imageView.setMinimumScaleType(3);
                imageView.setMinScale(ImageUtil.getSmallImageMinScale((Context)this.activity, imagePath));
                imageView.setMaxScale(ImageUtil.getSmallImageMaxScale((Context)this.activity, imagePath));
                imageView.setDoubleTapZoomScale(ImageUtil.getSmallImageMaxScale((Context)this.activity, imagePath));
            } else {
                imageView.setMinimumScaleType(1);
                imageView.setMinScale(ImagePreview.getInstance().getMinScale());
                imageView.setMaxScale(ImagePreview.getInstance().getMaxScale());
                imageView.setDoubleTapZoomScale(ImagePreview.getInstance().getMediumScale());
            }
        }
    }

    private void loadImageStandard(String imagePath, SubsamplingScaleImageViewDragClose imageView, ImageView imageGif, final ProgressBar progressBar) {
        imageGif.setVisibility(8);
        imageView.setVisibility(0);
        this.setImageSpec(imagePath, imageView);
        imageView.setOrientation(-1);
        ImageSource imageSource = ImageSource.uri(Uri.fromFile((File)new File(imagePath)));
        if (ImageUtil.isBmpImageWithMime(imagePath, imagePath)) {
            imageSource.tilingDisabled();
        }
        imageView.setImage(imageSource);
        imageView.setOnImageEventListener(new SimpleOnImageEventListener(){

            @Override
            public void onReady() {
                progressBar.setVisibility(8);
            }
        });
    }

    private void loadImageSpec(String imageUrl, String imagePath, final SubsamplingScaleImageViewDragClose imageView, final ImageView imageSpec, final ProgressBar progressBar) {
        imageSpec.setVisibility(0);
        imageView.setVisibility(8);
        boolean isGifFile = ImageUtil.isGifImageWithMime(imageUrl, imagePath);
        if (isGifFile) {
            Glide.with((FragmentActivity)this.activity).asGif().load(imagePath).apply(((RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.RESOURCE)).error(ImagePreview.getInstance().getErrorPlaceHolder())).listener((RequestListener)new RequestListener<GifDrawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                    progressBar.setVisibility(8);
                    imageSpec.setVisibility(8);
                    imageView.setVisibility(0);
                    imageView.setImage(ImageSource.resource(ImagePreview.getInstance().getErrorPlaceHolder()));
                    return false;
                }

                public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                    progressBar.setVisibility(8);
                    return false;
                }
            }).into(imageSpec);
        } else {
            Glide.with((FragmentActivity)this.activity).load(imageUrl).apply(((RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.RESOURCE)).error(ImagePreview.getInstance().getErrorPlaceHolder())).listener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    progressBar.setVisibility(8);
                    imageSpec.setVisibility(8);
                    imageView.setVisibility(0);
                    imageView.setImage(ImageSource.resource(ImagePreview.getInstance().getErrorPlaceHolder()));
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    progressBar.setVisibility(8);
                    return false;
                }
            }).into(imageSpec);
        }
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        String originUrl = this.imageInfo.get(position).getOriginUrl();
        try {
            SubsamplingScaleImageViewDragClose imageViewDragClose;
            if (this.imageHashMap != null && (imageViewDragClose = this.imageHashMap.get(originUrl)) != null) {
                imageViewDragClose.resetScaleAndCenter();
                imageViewDragClose.destroyDrawingCache();
                imageViewDragClose.recycle();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PhotoView photoView;
            if (this.imageGifHashMap != null && (photoView = this.imageGifHashMap.get(originUrl)) != null) {
                photoView.destroyDrawingCache();
                photoView.setImageBitmap(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ImageLoader.clearMemory(this.activity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

