/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.glide.progress;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private static final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private final String url;
    private final InternalProgressListener internalProgressListener;
    private final ResponseBody responseBody;
    private BufferedSource bufferedSource;

    ProgressResponseBody(String url, InternalProgressListener internalProgressListener, ResponseBody responseBody) {
        this.url = url;
        this.internalProgressListener = internalProgressListener;
        this.responseBody = responseBody;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            long lastTotalBytesRead;

            public long read(@NonNull Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead == -1L ? 0L : bytesRead;
                if (ProgressResponseBody.this.internalProgressListener != null && this.lastTotalBytesRead != this.totalBytesRead) {
                    this.lastTotalBytesRead = this.totalBytesRead;
                    mainThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ProgressResponseBody.this.internalProgressListener.onProgress(ProgressResponseBody.this.url, totalBytesRead, ProgressResponseBody.this.contentLength());
                        }
                    });
                }
                return bytesRead;
            }
        };
    }

    static interface InternalProgressListener {
        public void onProgress(String var1, long var2, long var4);
    }
}

