/*
 * Decompiled with CFR 0.152.
 */
package com.shashank.sony.fancygifdialoglib;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.shashank.sony.fancygifdialoglib.FancyGifDialogListener;
import com.shashank.sony.fancygifdialoglib.R;
import pl.droidsonroids.gif.GifImageView;

public class FancyGifDialog {
    private String title;
    private String message;
    private String positiveBtnText;
    private String negativeBtnText;
    @ColorRes
    private int pBtnColor;
    @ColorRes
    private int nBtnColor;
    private Context context;
    private FancyGifDialogListener pListener;
    private FancyGifDialogListener nListener;
    private DialogInterface.OnCancelListener cancelListener;
    private boolean cancel;
    int gifImageResource;

    private FancyGifDialog(Builder builder) {
        this.title = builder.title;
        this.message = builder.message;
        this.context = builder.context;
        this.pListener = builder.pListener;
        this.nListener = builder.nListener;
        this.pBtnColor = builder.pBtnColor;
        this.nBtnColor = builder.nBtnColor;
        this.positiveBtnText = builder.positiveBtnText;
        this.negativeBtnText = builder.negativeBtnText;
        this.gifImageResource = builder.gifImageResource;
        this.cancel = builder.cancel;
        this.cancelListener = builder.cancelListener;
    }

    public static class Builder {
        private String title;
        private String message;
        private String positiveBtnText;
        private String negativeBtnText;
        @ColorRes
        private int pBtnColor;
        @ColorRes
        private int nBtnColor;
        private Context context;
        private FancyGifDialogListener pListener;
        private FancyGifDialogListener nListener;
        private boolean cancel;
        int gifImageResource;
        private DialogInterface.OnCancelListener cancelListener;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            return this.setTitle(this.context.getString(title));
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int message) {
            return this.setMessage(this.context.getString(message));
        }

        public Builder setPositiveBtnText(String positiveBtnText) {
            this.positiveBtnText = positiveBtnText;
            return this;
        }

        public Builder setPositiveBtnText(@StringRes int positiveBtnText) {
            return this.setPositiveBtnText(this.context.getString(positiveBtnText));
        }

        public Builder setPositiveBtnBackground(@ColorRes int pBtnColor) {
            this.pBtnColor = pBtnColor;
            return this;
        }

        public Builder setNegativeBtnText(String negativeBtnText) {
            this.negativeBtnText = negativeBtnText;
            return this;
        }

        public Builder setNegativeBtnText(@StringRes int negativeBtnText) {
            return this.setNegativeBtnText(this.context.getString(negativeBtnText));
        }

        public Builder setNegativeBtnBackground(@ColorRes int nBtnColor) {
            this.nBtnColor = nBtnColor;
            return this;
        }

        public Builder OnPositiveClicked(FancyGifDialogListener pListener) {
            this.pListener = pListener;
            return this;
        }

        public Builder OnNegativeClicked(FancyGifDialogListener nListener) {
            this.nListener = nListener;
            return this;
        }

        public Builder isCancellable(boolean cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener cancelListener) {
            this.cancelListener = cancelListener;
            return this;
        }

        public Builder setGifResource(int gifImageResource) {
            this.gifImageResource = gifImageResource;
            return this;
        }

        public FancyGifDialog build() {
            final Dialog dialog = new Dialog(this.context);
            dialog.requestWindowFeature(1);
            if (dialog.getWindow() != null) {
                dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            }
            dialog.setCancelable(this.cancel);
            dialog.setContentView(R.layout.fancygifdialog);
            TextView title1 = (TextView)dialog.findViewById(R.id.title);
            TextView message1 = (TextView)dialog.findViewById(R.id.message);
            Button nBtn = (Button)dialog.findViewById(R.id.negativeBtn);
            Button pBtn = (Button)dialog.findViewById(R.id.positiveBtn);
            GifImageView gifImageView = (GifImageView)dialog.findViewById(R.id.gifImageView);
            gifImageView.setImageResource(this.gifImageResource);
            title1.setText((CharSequence)this.title);
            message1.setText((CharSequence)this.message);
            if (this.positiveBtnText != null) {
                pBtn.setText((CharSequence)this.positiveBtnText);
            }
            if (this.negativeBtnText != null) {
                nBtn.setText((CharSequence)this.negativeBtnText);
            }
            GradientDrawable pbgShape = (GradientDrawable)pBtn.getBackground();
            pbgShape.setColor(ContextCompat.getColor((Context)this.context, (int)this.pBtnColor));
            GradientDrawable nbgShape = (GradientDrawable)nBtn.getBackground();
            nbgShape.setColor(ContextCompat.getColor((Context)this.context, (int)this.nBtnColor));
            if (this.pListener != null) {
                pBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Builder.this.pListener.OnClick();
                        dialog.dismiss();
                    }
                });
            } else {
                pBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        dialog.dismiss();
                    }
                });
            }
            if (this.nListener != null) {
                nBtn.setVisibility(0);
                nBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Builder.this.nListener.OnClick();
                        dialog.dismiss();
                    }
                });
            }
            if (this.cancelListener != null) {
                dialog.setOnCancelListener(this.cancelListener);
            }
            dialog.show();
            return new FancyGifDialog(this);
        }
    }
}

