/*
 * Decompiled with CFR 0.152.
 */
package com.sandro.bitcoinpaymenturi;

import com.sandro.bitcoinpaymenturi.model.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitcoinPaymentURI {
    private static final String SCHEME = "bitcoin:";
    private static final String PARAMETER_AMOUNT = "amount";
    private static final String PARAMETER_LABEL = "label";
    private static final String PARAMETER_MESSAGE = "message";
    private final String address;
    private final HashMap<String, Parameter> parameters;

    private BitcoinPaymentURI(Builder builder) {
        this.address = builder.address;
        this.parameters = new HashMap();
        if (builder.amount != null) {
            this.parameters.put(PARAMETER_AMOUNT, new Parameter(String.valueOf(builder.amount), false));
        }
        if (builder.label != null) {
            this.parameters.put(PARAMETER_LABEL, new Parameter(builder.label, false));
        }
        if (builder.message != null) {
            this.parameters.put(PARAMETER_MESSAGE, new Parameter(builder.message, false));
        }
        if (builder.otherParameters != null) {
            this.parameters.putAll(builder.otherParameters);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public Double getAmount() {
        if (this.parameters.get(PARAMETER_AMOUNT) == null) {
            return null;
        }
        return Double.valueOf(this.parameters.get(PARAMETER_AMOUNT).getValue());
    }

    public String getLabel() {
        if (this.parameters.get(PARAMETER_LABEL) == null) {
            return null;
        }
        return this.parameters.get(PARAMETER_LABEL).getValue();
    }

    public String getMessage() {
        if (this.parameters.get(PARAMETER_MESSAGE) == null) {
            return null;
        }
        return this.parameters.get(PARAMETER_MESSAGE).getValue();
    }

    public HashMap<String, Parameter> getParameters() {
        HashMap<String, Parameter> filteredParameters = new HashMap<String, Parameter>(this.parameters);
        filteredParameters.remove(PARAMETER_AMOUNT);
        filteredParameters.remove(PARAMETER_LABEL);
        filteredParameters.remove(PARAMETER_MESSAGE);
        return filteredParameters;
    }

    public String getURI() {
        String queryParameters = null;
        try {
            for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
                if (queryParameters == null) {
                    if (entry.getValue().isRequired().booleanValue()) {
                        queryParameters = String.format("req-%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8").replace("+", "%20"), URLEncoder.encode(entry.getValue().getValue(), "UTF-8").replace("+", "%20"));
                        continue;
                    }
                    queryParameters = String.format("%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8").replace("+", "%20"), URLEncoder.encode(entry.getValue().getValue(), "UTF-8").replace("+", "%20"));
                    continue;
                }
                if (entry.getValue().isRequired().booleanValue()) {
                    queryParameters = String.format("%s&req-%s=%s", queryParameters, URLEncoder.encode(entry.getKey(), "UTF-8").replace("+", "%20"), URLEncoder.encode(entry.getValue().getValue(), "UTF-8").replace("+", "%20"));
                    continue;
                }
                queryParameters = String.format("%s&%s=%s", queryParameters, URLEncoder.encode(entry.getKey(), "UTF-8").replace("+", "%20"), URLEncoder.encode(entry.getValue().getValue(), "UTF-8").replace("+", "%20"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        return String.format("%s%s%s", SCHEME, this.getAddress(), queryParameters == null ? "" : String.format("?%s", queryParameters));
    }

    public static BitcoinPaymentURI parse(String string) {
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return null;
        }
        if (!string.toLowerCase().startsWith(SCHEME)) {
            return null;
        }
        String bitcoinPaymentURIWithoutScheme = string.replaceFirst(SCHEME, "");
        ArrayList<String> bitcoinPaymentURIElements = new ArrayList<String>(Arrays.asList(bitcoinPaymentURIWithoutScheme.split("\\?")));
        if (bitcoinPaymentURIElements.size() != 1 && bitcoinPaymentURIElements.size() != 2) {
            return null;
        }
        if (bitcoinPaymentURIElements.get(0).length() == 0) {
            return null;
        }
        if (bitcoinPaymentURIElements.size() == 1) {
            return new Builder().address(bitcoinPaymentURIElements.get(0)).build();
        }
        List<String> queryParametersList = Arrays.asList(bitcoinPaymentURIElements.get(1).split("&"));
        if (queryParametersList.isEmpty()) {
            return new Builder().address(bitcoinPaymentURIElements.get(0)).build();
        }
        HashMap<String, String> queryParametersFiltered = new HashMap<String, String>();
        for (String query : queryParametersList) {
            String[] queryParameter = query.split("=");
            try {
                queryParametersFiltered.put(queryParameter[0], queryParameter[1]);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        Builder bitcoinPaymentURIBuilder = new Builder().address(bitcoinPaymentURIElements.get(0));
        if (queryParametersFiltered.containsKey(PARAMETER_AMOUNT)) {
            bitcoinPaymentURIBuilder.amount(Double.valueOf((String)queryParametersFiltered.get(PARAMETER_AMOUNT)));
            queryParametersFiltered.remove(PARAMETER_AMOUNT);
        }
        if (queryParametersFiltered.containsKey(PARAMETER_LABEL)) {
            bitcoinPaymentURIBuilder.label((String)queryParametersFiltered.get(PARAMETER_LABEL));
            queryParametersFiltered.remove(PARAMETER_LABEL);
        }
        if (queryParametersFiltered.containsKey(PARAMETER_MESSAGE)) {
            bitcoinPaymentURIBuilder.message((String)queryParametersFiltered.get(PARAMETER_MESSAGE));
            queryParametersFiltered.remove(PARAMETER_MESSAGE);
        }
        for (Map.Entry entry : queryParametersFiltered.entrySet()) {
            bitcoinPaymentURIBuilder.parameter((String)entry.getKey(), (String)entry.getValue());
        }
        return bitcoinPaymentURIBuilder.build();
    }

    public static class Builder {
        private String address;
        private Double amount;
        private String label;
        private String message;
        private HashMap<String, Parameter> otherParameters;

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder parameter(String key, String value) {
            if (this.otherParameters == null) {
                this.otherParameters = new HashMap();
            }
            if (key.startsWith("req-")) {
                this.otherParameters.put(key.replace("req-", ""), new Parameter(value, true));
                return this;
            }
            this.otherParameters.put(key, new Parameter(value, false));
            return this;
        }

        public Builder requiredParameter(String key, String value) {
            if (this.otherParameters == null) {
                this.otherParameters = new HashMap();
            }
            this.otherParameters.put(key, new Parameter(value, true));
            return this;
        }

        public BitcoinPaymentURI build() {
            return new BitcoinPaymentURI(this);
        }
    }
}

