/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.utils;

import android.graphics.Paint;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;

public class TextViewUtils {
    private static TextViewUtils instance = null;

    private TextViewUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextViewUtils get() {
        if (instance != null) return instance;
        Class<TextViewUtils> clazz = TextViewUtils.class;
        synchronized (TextViewUtils.class) {
            if (instance != null) return instance;
            instance = new TextViewUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public float getTextWidth(TextView view, int drawableWidth, int paddingLeft, int paddingRight, int drawablePaddingHorizontal) {
        float textWidth;
        if (view == null) {
            return 0.0f;
        }
        String originalText = view.getText().toString();
        if (originalText.contains("\n")) {
            String[] originalTextArray = originalText.split("\n");
            int arrayLen = originalTextArray.length;
            ArrayList<Float> widthList = new ArrayList<Float>(arrayLen);
            for (int i = 0; i < arrayLen; ++i) {
                widthList.add(Float.valueOf(view.getPaint().measureText(originalTextArray[i])));
            }
            textWidth = ((Float)Collections.max(widthList)).floatValue();
        } else {
            textWidth = view.getPaint().measureText(originalText);
        }
        int maxWidth = view.getWidth() - drawableWidth - paddingLeft - paddingRight - drawablePaddingHorizontal;
        if (textWidth > (float)maxWidth) {
            textWidth = maxWidth;
        }
        return textWidth;
    }

    public float getTextHeight(TextView view, int drawableHeight, int paddingTop, int paddingBottom, int drawablePaddingVertical) {
        int maxHeight;
        if (view == null) {
            return 0.0f;
        }
        Paint.FontMetrics fontMetrics = view.getPaint().getFontMetrics();
        float singleLineHeight = Math.abs(fontMetrics.bottom - fontMetrics.top);
        float textHeight = singleLineHeight * (float)view.getLineCount();
        if (textHeight > (float)(maxHeight = view.getHeight() - drawableHeight - paddingTop - paddingBottom - drawablePaddingVertical)) {
            textHeight = maxHeight;
        }
        return textHeight;
    }
}

