/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.shadow;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import com.ruffian.library.widget.utils.ReflectUtils;
import java.util.Arrays;

public class ShadowBitmapDrawable
extends BitmapDrawable {
    private int mShadowColor;
    private float mShadowRadius;
    private float[] mRoundRadii;
    private int mShadowDx;
    private int mShadowDy;
    private RectF mBoundsF = new RectF();

    public void updateParameter(int shadowColor, float shadowRadius, int shadowDx, int shadowDy, float[] roundRadii) {
        boolean needUpdate = false;
        if (this.mShadowColor != shadowColor || this.mShadowRadius != shadowRadius || this.mShadowDx != shadowDx || this.mShadowDy != shadowDy || !Arrays.equals(this.mRoundRadii, roundRadii)) {
            needUpdate = true;
        }
        this.mShadowColor = shadowColor;
        this.mRoundRadii = roundRadii;
        this.mShadowRadius = shadowRadius;
        this.mShadowDx = shadowDx;
        this.mShadowDy = shadowDy;
        if (needUpdate) {
            Bitmap bitmap = this.makeShadowBitmap((int)this.mBoundsF.width(), (int)this.mBoundsF.height(), this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mShadowColor, this.mRoundRadii);
            ReflectUtils.invokeMethod((Object)this, "setBitmap", new Class[]{Bitmap.class}, new Object[]{bitmap});
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (bounds.right - bounds.left > 0 && bounds.bottom - bounds.top > 0) {
            this.updateBounds(bounds);
        }
    }

    private void updateBounds(Rect bounds) {
        if (bounds == null) {
            bounds = this.getBounds();
        }
        float left = (float)bounds.left + this.mShadowRadius + (float)Math.abs(this.mShadowDx);
        float right = (float)bounds.right - this.mShadowRadius - (float)Math.abs(this.mShadowDx);
        float top = (float)bounds.top + this.mShadowRadius + (float)Math.abs(this.mShadowDy);
        float bottom = (float)bounds.bottom - this.mShadowRadius - (float)Math.abs(this.mShadowDy);
        this.mBoundsF.set(left, top, right, bottom);
        Bitmap bitmap = this.makeShadowBitmap((int)this.mBoundsF.width(), (int)this.mBoundsF.height(), this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mShadowColor, this.mRoundRadii);
        ReflectUtils.invokeMethod((Object)this, "setBitmap", new Class[]{Bitmap.class}, new Object[]{bitmap});
    }

    public Bitmap makeShadowBitmap(int shadowWidth, int shadowHeight, float shadowRadius, float dx, float dy, int shadowColor, float[] radii) {
        if (shadowWidth <= 0 || shadowHeight <= 0) {
            return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        }
        Bitmap output = Bitmap.createBitmap((int)shadowWidth, (int)shadowHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(output);
        RectF shadowRect = new RectF(shadowRadius, shadowRadius, (float)shadowWidth - shadowRadius, (float)shadowHeight - shadowRadius);
        shadowRect.top += Math.abs(dy);
        shadowRect.bottom -= Math.abs(dy);
        shadowRect.left += Math.abs(dx);
        shadowRect.right -= Math.abs(dx);
        Paint shadowPaint = new Paint(5);
        shadowPaint.setColor(shadowColor);
        shadowPaint.setShadowLayer(shadowRadius, dx, dy, shadowColor);
        Path path = new Path();
        path.addRoundRect(shadowRect, radii, Path.Direction.CW);
        canvas.drawPath(path, shadowPaint);
        return output;
    }
}

