/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.StyleableRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.ruffian.library.widget.R;
import com.ruffian.library.widget.helper.RBaseHelper;
import com.ruffian.library.widget.iface.ITextViewFeature;
import com.ruffian.library.widget.utils.TextViewUtils;

public class RTextViewHelper
extends RBaseHelper<TextView>
implements ITextViewFeature {
    public static final int ICON_DIR_LEFT = 1;
    public static final int ICON_DIR_TOP = 2;
    public static final int ICON_DIR_RIGHT = 3;
    public static final int ICON_DIR_BOTTOM = 4;
    private Drawable mIcon = null;
    private Drawable mIconNormal;
    private Drawable mIconPressed;
    private Drawable mIconUnable;
    private Drawable mIconSelected;
    private Drawable mIconChecked;
    private int mIconHeight;
    private int mIconWidth;
    private int mIconDirection;
    private int mIconHeightLeft;
    private int mIconWidthLeft;
    private int mIconHeightRight;
    private int mIconWidthRight;
    private int mIconHeightTop;
    private int mIconWidthTop;
    private int mIconHeightBottom;
    private int mIconWidthBottom;
    private Drawable mIconLeft = null;
    private Drawable mIconNormalLeft;
    private Drawable mIconPressedLeft;
    private Drawable mIconUnableLeft;
    private Drawable mIconSelectedLeft;
    private Drawable mIconCheckedLeft;
    private Drawable mIconTop = null;
    private Drawable mIconNormalTop;
    private Drawable mIconPressedTop;
    private Drawable mIconUnableTop;
    private Drawable mIconSelectedTop;
    private Drawable mIconCheckedTop;
    private Drawable mIconBottom = null;
    private Drawable mIconNormalBottom;
    private Drawable mIconPressedBottom;
    private Drawable mIconUnableBottom;
    private Drawable mIconSelectedBottom;
    private Drawable mIconCheckedBottom;
    private Drawable mIconRight = null;
    private Drawable mIconNormalRight;
    private Drawable mIconPressedRight;
    private Drawable mIconUnableRight;
    private Drawable mIconSelectedRight;
    private Drawable mIconCheckedRight;
    protected int mTextColorNormal = 0;
    protected int mTextColorPressed = 0;
    protected int mTextColorUnable = 0;
    protected int mTextColorSelected = 0;
    protected int mTextColorChecked = 0;
    protected ColorStateList mTextColorStateList;
    protected int[][] states = new int[6][];
    private String mTypefacePath;
    private boolean mDrawableWithText = false;
    protected boolean mHasPressedTextColor = false;
    protected boolean mHasUnableTextColor = false;
    protected boolean mHasSelectedTextColor = false;
    protected boolean mHasCheckedTextColor = false;
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    private String mCacheSingleIconPaddingVale;
    private String mCacheMultipleIconPaddingVale;

    public RTextViewHelper(Context context, TextView view, AttributeSet attrs) {
        super(context, view, attrs);
        this.initAttributeSet(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (context == null || attrs == null) {
            this.setup();
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RTextView);
        this.mIconNormalLeft = this.getDrawable(context, a, R.styleable.RTextView_icon_normal_left);
        this.mIconPressedLeft = this.getDrawable(context, a, R.styleable.RTextView_icon_pressed_left);
        this.mIconUnableLeft = this.getDrawable(context, a, R.styleable.RTextView_icon_unable_left);
        this.mIconSelectedLeft = this.getDrawable(context, a, R.styleable.RTextView_icon_selected_left);
        this.mIconCheckedLeft = this.getDrawable(context, a, R.styleable.RTextView_icon_checked_left);
        this.mIconNormalRight = this.getDrawable(context, a, R.styleable.RTextView_icon_normal_right);
        this.mIconPressedRight = this.getDrawable(context, a, R.styleable.RTextView_icon_pressed_right);
        this.mIconUnableRight = this.getDrawable(context, a, R.styleable.RTextView_icon_unable_right);
        this.mIconSelectedRight = this.getDrawable(context, a, R.styleable.RTextView_icon_selected_right);
        this.mIconCheckedRight = this.getDrawable(context, a, R.styleable.RTextView_icon_checked_right);
        this.mIconNormalTop = this.getDrawable(context, a, R.styleable.RTextView_icon_normal_top);
        this.mIconPressedTop = this.getDrawable(context, a, R.styleable.RTextView_icon_pressed_top);
        this.mIconUnableTop = this.getDrawable(context, a, R.styleable.RTextView_icon_unable_top);
        this.mIconSelectedTop = this.getDrawable(context, a, R.styleable.RTextView_icon_selected_top);
        this.mIconCheckedTop = this.getDrawable(context, a, R.styleable.RTextView_icon_checked_top);
        this.mIconNormalBottom = this.getDrawable(context, a, R.styleable.RTextView_icon_normal_bottom);
        this.mIconPressedBottom = this.getDrawable(context, a, R.styleable.RTextView_icon_pressed_bottom);
        this.mIconUnableBottom = this.getDrawable(context, a, R.styleable.RTextView_icon_unable_bottom);
        this.mIconSelectedBottom = this.getDrawable(context, a, R.styleable.RTextView_icon_selected_bottom);
        this.mIconCheckedBottom = this.getDrawable(context, a, R.styleable.RTextView_icon_checked_bottom);
        Drawable drawableLeft = this.getDrawable(context, a, R.styleable.RTextView_android_drawableLeft);
        Drawable drawableRight = this.getDrawable(context, a, R.styleable.RTextView_android_drawableRight);
        Drawable drawableTop = this.getDrawable(context, a, R.styleable.RTextView_android_drawableTop);
        Drawable drawableBottom = this.getDrawable(context, a, R.styleable.RTextView_android_drawableBottom);
        Drawable drawableStart = this.getDrawable(context, a, R.styleable.RTextView_android_drawableStart);
        Drawable drawableEnd = this.getDrawable(context, a, R.styleable.RTextView_android_drawableEnd);
        this.mIconNormal = this.getDrawable(context, a, R.styleable.RTextView_icon_src_normal);
        this.mIconPressed = this.getDrawable(context, a, R.styleable.RTextView_icon_src_pressed);
        this.mIconUnable = this.getDrawable(context, a, R.styleable.RTextView_icon_src_unable);
        this.mIconSelected = this.getDrawable(context, a, R.styleable.RTextView_icon_src_selected);
        this.mIconChecked = this.getDrawable(context, a, R.styleable.RTextView_icon_src_checked);
        if (!RTextViewHelper.isRtl()) {
            if (drawableStart != null) {
                drawableLeft = drawableStart;
            }
            if (drawableEnd != null) {
                drawableRight = drawableEnd;
            }
        } else {
            if (drawableEnd != null) {
                drawableLeft = drawableEnd;
            }
            if (drawableStart != null) {
                drawableRight = drawableStart;
            }
        }
        if (drawableLeft != null) {
            this.mIconNormalLeft = drawableLeft;
        }
        if (drawableRight != null) {
            this.mIconNormalRight = drawableRight;
        }
        if (drawableTop != null) {
            this.mIconNormalTop = drawableTop;
        }
        if (drawableBottom != null) {
            this.mIconNormalBottom = drawableBottom;
        }
        this.mIconWidthLeft = a.getDimensionPixelSize(R.styleable.RTextView_icon_width_left, 0);
        this.mIconHeightLeft = a.getDimensionPixelSize(R.styleable.RTextView_icon_height_left, 0);
        this.mIconWidthRight = a.getDimensionPixelSize(R.styleable.RTextView_icon_width_right, 0);
        this.mIconHeightRight = a.getDimensionPixelSize(R.styleable.RTextView_icon_height_right, 0);
        this.mIconWidthBottom = a.getDimensionPixelSize(R.styleable.RTextView_icon_width_bottom, 0);
        this.mIconHeightBottom = a.getDimensionPixelSize(R.styleable.RTextView_icon_height_bottom, 0);
        this.mIconWidthTop = a.getDimensionPixelSize(R.styleable.RTextView_icon_width_top, 0);
        this.mIconHeightTop = a.getDimensionPixelSize(R.styleable.RTextView_icon_height_top, 0);
        this.mIconWidth = a.getDimensionPixelSize(R.styleable.RTextView_icon_width, 0);
        this.mIconHeight = a.getDimensionPixelSize(R.styleable.RTextView_icon_height, 0);
        this.mIconDirection = a.getInt(R.styleable.RTextView_icon_direction, 1);
        this.mTextColorNormal = a.getColor(R.styleable.RTextView_text_color_normal, ((TextView)this.mView).getCurrentTextColor());
        this.mTextColorPressed = a.getColor(R.styleable.RTextView_text_color_pressed, 0);
        this.mTextColorUnable = a.getColor(R.styleable.RTextView_text_color_unable, 0);
        this.mTextColorSelected = a.getColor(R.styleable.RTextView_text_color_selected, 0);
        this.mTextColorChecked = a.getColor(R.styleable.RTextView_text_color_checked, 0);
        this.mTypefacePath = a.getString(R.styleable.RTextView_text_typeface);
        this.mDrawableWithText = a.getBoolean(R.styleable.RTextView_icon_with_text, false);
        a.recycle();
        this.setup();
    }

    private void setupDefaultValue(boolean init) {
        if (init) {
            this.mHasPressedTextColor = this.mTextColorPressed != 0;
            this.mHasUnableTextColor = this.mTextColorUnable != 0;
            this.mHasSelectedTextColor = this.mTextColorSelected != 0;
            boolean bl = this.mHasCheckedTextColor = this.mTextColorChecked != 0;
        }
        if (!this.mHasPressedTextColor) {
            this.mTextColorPressed = this.mTextColorNormal;
        }
        if (!this.mHasUnableTextColor) {
            this.mTextColorUnable = this.mTextColorNormal;
        }
        if (!this.mHasSelectedTextColor) {
            this.mTextColorSelected = this.mTextColorNormal;
        }
        if (!this.mHasCheckedTextColor) {
            this.mTextColorChecked = this.mTextColorNormal;
        }
    }

    private void setup() {
        if (!((TextView)this.mView).isEnabled()) {
            this.mIcon = this.mIconUnable;
            this.mIconLeft = this.mIconUnableLeft;
            this.mIconRight = this.mIconUnableRight;
            this.mIconTop = this.mIconUnableTop;
            this.mIconBottom = this.mIconUnableBottom;
        } else if (((TextView)this.mView).isSelected()) {
            this.mIcon = this.mIconSelected;
            this.mIconLeft = this.mIconSelectedLeft;
            this.mIconRight = this.mIconSelectedRight;
            this.mIconTop = this.mIconSelectedTop;
            this.mIconBottom = this.mIconSelectedBottom;
        } else if (this.isCompoundButtonChecked()) {
            this.mIcon = this.mIconChecked;
            this.mIconLeft = this.mIconCheckedLeft;
            this.mIconRight = this.mIconCheckedRight;
            this.mIconTop = this.mIconCheckedTop;
            this.mIconBottom = this.mIconCheckedBottom;
        } else {
            this.mIcon = this.mIconNormal;
            this.mIconLeft = this.mIconNormalLeft;
            this.mIconRight = this.mIconNormalRight;
            this.mIconTop = this.mIconNormalTop;
            this.mIconBottom = this.mIconNormalBottom;
        }
        this.states[0] = new int[]{-16842910};
        this.states[1] = new int[]{16842908};
        this.states[2] = new int[]{16842919};
        this.states[3] = new int[]{0x10100A0};
        this.states[4] = new int[]{0x10100A1};
        this.states[5] = new int[]{16842910};
        this.setupDefaultValue(true);
        this.setTextColor();
        this.setIcon();
        this.setTypeface();
    }

    private Drawable getDrawable(Context context, TypedArray a, @StyleableRes int index) {
        Drawable drawable = null;
        if (Build.VERSION.SDK_INT >= 21) {
            drawable = a.getDrawable(index);
        } else {
            int resId = a.getResourceId(index, -1);
            if (resId != -1) {
                drawable = AppCompatResources.getDrawable((Context)context, (int)resId);
            }
        }
        return drawable;
    }

    public RTextViewHelper setTypeface(String typefacePath) {
        this.mTypefacePath = typefacePath;
        this.setTypeface();
        return this;
    }

    public String getTypefacePath() {
        return this.mTypefacePath;
    }

    private void setTypeface() {
        if (!TextUtils.isEmpty((CharSequence)this.mTypefacePath)) {
            AssetManager assetManager = this.mContext.getAssets();
            Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)this.mTypefacePath);
            ((TextView)this.mView).setTypeface(typeface);
        }
    }

    @Deprecated
    public RTextViewHelper setIconNormal(Drawable icon) {
        this.mIconNormal = icon;
        this.mIcon = icon;
        this.setIcon();
        return this;
    }

    @Deprecated
    public Drawable getIconNormal() {
        return this.mIconNormal;
    }

    @Deprecated
    public RTextViewHelper setIconPressed(Drawable icon) {
        this.mIconPressed = icon;
        this.mIcon = icon;
        this.setIcon();
        return this;
    }

    @Deprecated
    public Drawable getIconPressed() {
        return this.mIconPressed;
    }

    @Deprecated
    public RTextViewHelper setIconUnable(Drawable icon) {
        this.mIconUnable = icon;
        this.mIcon = icon;
        this.setIcon();
        return this;
    }

    @Deprecated
    public Drawable getIconUnable() {
        return this.mIconUnable;
    }

    @Deprecated
    public RTextViewHelper setIconSelected(Drawable icon) {
        this.mIconSelected = icon;
        this.mIcon = icon;
        this.setIcon();
        return this;
    }

    @Deprecated
    public Drawable getIconSelected() {
        return this.mIconSelected;
    }

    @Deprecated
    public RTextViewHelper setIconChecked(Drawable icon) {
        this.mIconChecked = icon;
        this.mIcon = icon;
        this.setIcon(icon);
        return this;
    }

    @Deprecated
    public Drawable getIconChecked() {
        return this.mIconChecked;
    }

    @Deprecated
    public RTextViewHelper setIconSize(int iconWidth, int iconHeight) {
        this.mIconWidth = iconWidth;
        this.mIconHeight = iconHeight;
        this.setIcon();
        return this;
    }

    @Deprecated
    public RTextViewHelper setIconWidth(int iconWidth) {
        this.mIconWidth = iconWidth;
        this.setIcon();
        return this;
    }

    @Deprecated
    public int getIconWidth() {
        return this.mIconWidth;
    }

    @Deprecated
    public RTextViewHelper setIconHeight(int iconHeight) {
        this.mIconHeight = iconHeight;
        this.setIcon();
        return this;
    }

    @Deprecated
    public int getIconHeight() {
        return this.mIconHeight;
    }

    @Deprecated
    public RTextViewHelper setIconDirection(int iconDirection) {
        this.mIconDirection = iconDirection;
        this.setIcon();
        return this;
    }

    @Deprecated
    public int getIconDirection() {
        return this.mIconDirection;
    }

    public RTextViewHelper setIconNormalLeft(Drawable icon) {
        this.mIconNormalLeft = icon;
        this.mIconLeft = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconNormalRight(Drawable icon) {
        this.mIconNormalRight = icon;
        this.mIconRight = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconNormalTop(Drawable icon) {
        this.mIconNormalTop = icon;
        this.mIconTop = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconNormalBottom(Drawable icon) {
        this.mIconNormalBottom = icon;
        this.mIconBottom = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconNormalLeft() {
        return this.mIconNormalLeft;
    }

    public Drawable getIconNormalRight() {
        return this.mIconNormalRight;
    }

    public Drawable getIconNormalTop() {
        return this.mIconNormalTop;
    }

    public Drawable getIconNormalBottom() {
        return this.mIconNormalBottom;
    }

    public RTextViewHelper setIconPressedLeft(Drawable icon) {
        this.mIconPressedLeft = icon;
        this.mIconLeft = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconPressedRight(Drawable icon) {
        this.mIconPressedRight = icon;
        this.mIconRight = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconPressedTop(Drawable icon) {
        this.mIconPressedTop = icon;
        this.mIconTop = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconPressedBottom(Drawable icon) {
        this.mIconPressedBottom = icon;
        this.mIconBottom = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconPressedLeft() {
        return this.mIconPressedLeft;
    }

    public Drawable getIconPressedRight() {
        return this.mIconPressedRight;
    }

    public Drawable getIconPressedTop() {
        return this.mIconPressedTop;
    }

    public Drawable getIconPressedBottom() {
        return this.mIconPressedBottom;
    }

    public RTextViewHelper setIconUnableLeft(Drawable icon) {
        this.mIconUnableLeft = icon;
        this.mIconLeft = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconUnableRight(Drawable icon) {
        this.mIconUnableRight = icon;
        this.mIconRight = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconUnableTop(Drawable icon) {
        this.mIconUnableTop = icon;
        this.mIconTop = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconUnableBottom(Drawable icon) {
        this.mIconUnableBottom = icon;
        this.mIconBottom = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconUnableLeft() {
        return this.mIconUnableLeft;
    }

    public Drawable getIconUnableRight() {
        return this.mIconUnableRight;
    }

    public Drawable getIconUnableTop() {
        return this.mIconUnableTop;
    }

    public Drawable getIconUnableBottom() {
        return this.mIconUnableBottom;
    }

    public RTextViewHelper setIconSelectedLeft(Drawable icon) {
        this.mIconSelectedLeft = icon;
        this.mIconLeft = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconSelectedRight(Drawable icon) {
        this.mIconSelectedRight = icon;
        this.mIconRight = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconSelectedTop(Drawable icon) {
        this.mIconSelectedTop = icon;
        this.mIconTop = icon;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconSelectedBottom(Drawable icon) {
        this.mIconSelectedBottom = icon;
        this.mIconBottom = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconSelectedLeft() {
        return this.mIconSelectedLeft;
    }

    public Drawable getIconSelectedRight() {
        return this.mIconSelectedRight;
    }

    public Drawable getIconSelectedTop() {
        return this.mIconSelectedTop;
    }

    public Drawable getIconSelectedBottom() {
        return this.mIconSelectedBottom;
    }

    public RTextViewHelper setIconCheckedLeft(Drawable icon) {
        this.mIconCheckedLeft = icon;
        this.setIconLeft(icon);
        return this;
    }

    public RTextViewHelper setIconCheckedRight(Drawable icon) {
        this.mIconCheckedRight = icon;
        this.setIconRight(icon);
        return this;
    }

    public RTextViewHelper setIconCheckedTop(Drawable icon) {
        this.mIconCheckedTop = icon;
        this.setIconTop(icon);
        return this;
    }

    public RTextViewHelper setIconCheckedBottom(Drawable icon) {
        this.mIconCheckedBottom = icon;
        this.setIconBottom(icon);
        return this;
    }

    public Drawable getIconCheckedLeft() {
        return this.mIconCheckedLeft;
    }

    public Drawable getIconCheckedRight() {
        return this.mIconCheckedRight;
    }

    public Drawable getIconCheckedTop() {
        return this.mIconCheckedTop;
    }

    public Drawable getIconCheckedBottom() {
        return this.mIconCheckedBottom;
    }

    public RTextViewHelper setIconSizeLeft(int iconWidth, int iconHeight) {
        this.mIconWidthLeft = iconWidth;
        this.mIconHeightLeft = iconHeight;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconSizeRight(int iconWidth, int iconHeight) {
        this.mIconWidthRight = iconWidth;
        this.mIconHeightRight = iconHeight;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconSizeTop(int iconWidth, int iconHeight) {
        this.mIconWidthTop = iconWidth;
        this.mIconHeightTop = iconHeight;
        this.setIcon();
        return this;
    }

    public RTextViewHelper setIconSizeBottom(int iconWidth, int iconHeight) {
        this.mIconWidthBottom = iconWidth;
        this.mIconHeightBottom = iconHeight;
        this.setIcon();
        return this;
    }

    public int getIconWidthLeft() {
        return this.mIconWidthLeft;
    }

    public int getIconHeightLeft() {
        return this.mIconHeightLeft;
    }

    public int getIconWidthRight() {
        return this.mIconWidthRight;
    }

    public int getIconHeightRight() {
        return this.mIconHeightRight;
    }

    public int getIconWidthTop() {
        return this.mIconWidthTop;
    }

    public int getIconHeightTop() {
        return this.mIconHeightTop;
    }

    public int getIconWidthBottom() {
        return this.mIconWidthBottom;
    }

    public int getIconHeightBottom() {
        return this.mIconHeightBottom;
    }

    @Deprecated
    protected void setIcon(Drawable icon) {
        this.mIcon = icon;
        this.setIcon();
    }

    protected void setIconLeft(Drawable icon) {
        this.mIconLeft = icon;
        this.setIcon();
    }

    protected void setIconRight(Drawable icon) {
        this.mIconRight = icon;
        this.setIcon();
    }

    protected void setIconTop(Drawable icon) {
        this.mIconTop = icon;
        this.setIcon();
    }

    protected void setIconBottom(Drawable icon) {
        this.mIconBottom = icon;
        this.setIcon();
    }

    private void setIcon() {
        if (this.mIconHeightLeft == 0 && this.mIconWidthLeft == 0 && this.mIconLeft != null) {
            this.mIconWidthLeft = this.mIconLeft.getIntrinsicWidth();
            this.mIconHeightLeft = this.mIconLeft.getIntrinsicHeight();
        }
        if (this.mIconHeightRight == 0 && this.mIconWidthRight == 0 && this.mIconRight != null) {
            this.mIconWidthRight = this.mIconRight.getIntrinsicWidth();
            this.mIconHeightRight = this.mIconRight.getIntrinsicHeight();
        }
        if (this.mIconHeightTop == 0 && this.mIconWidthTop == 0 && this.mIconTop != null) {
            this.mIconWidthTop = this.mIconTop.getIntrinsicWidth();
            this.mIconHeightTop = this.mIconTop.getIntrinsicHeight();
        }
        if (this.mIconHeightBottom == 0 && this.mIconWidthBottom == 0 && this.mIconBottom != null) {
            this.mIconWidthBottom = this.mIconBottom.getIntrinsicWidth();
            this.mIconHeightBottom = this.mIconBottom.getIntrinsicHeight();
        }
        if (this.mIconHeight == 0 && this.mIconWidth == 0 && this.mIcon != null) {
            this.mIconWidth = this.mIcon.getIntrinsicWidth();
            this.mIconHeight = this.mIcon.getIntrinsicHeight();
        }
        if (this.isSingleDirection()) {
            this.setSingleCompoundDrawable(this.mIcon, this.mIconWidth, this.mIconHeight, this.mIconDirection);
        } else {
            this.setCompoundDrawables(this.mIconLeft, this.mIconRight, this.mIconTop, this.mIconBottom);
        }
    }

    private void setCompoundDrawables(Drawable drawableLeft, Drawable drawableRight, Drawable drawableTop, Drawable drawableBottom) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, this.mIconWidthLeft, this.mIconHeightLeft);
        }
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, this.mIconWidthRight, this.mIconHeightRight);
        }
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, this.mIconWidthTop, this.mIconHeightTop);
        }
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, this.mIconWidthBottom, this.mIconHeightBottom);
        }
        boolean rtl = RTextViewHelper.isRtl();
        ((TextView)this.mView).setCompoundDrawables(rtl ? drawableRight : drawableLeft, drawableTop, rtl ? drawableLeft : drawableRight, drawableBottom);
    }

    @Deprecated
    private void setSingleCompoundDrawable(Drawable drawable, int drawableWidth, int drawableHeight, int direction) {
        boolean rtl;
        if (drawable != null) {
            drawable.setBounds(0, 0, drawableWidth, drawableHeight);
        }
        if (rtl = RTextViewHelper.isRtl()) {
            ((TextView)this.mView).setCompoundDrawables((Drawable)(direction == 3 ? drawable : null), (Drawable)(direction == 2 ? drawable : null), (Drawable)(direction == 1 ? drawable : null), (Drawable)(direction == 4 ? drawable : null));
        } else {
            ((TextView)this.mView).setCompoundDrawables((Drawable)(direction == 1 ? drawable : null), (Drawable)(direction == 2 ? drawable : null), (Drawable)(direction == 3 ? drawable : null), (Drawable)(direction == 4 ? drawable : null));
        }
    }

    private void setSingleIconWithText() {
        String paddingStr;
        if (!this.mDrawableWithText || this.mView == null || ((TextView)this.mView).getWidth() == 0) {
            return;
        }
        int drawablePadding = ((TextView)this.mView).getCompoundDrawablePadding();
        int drawableWidth = this.mIconWidth;
        int drawableHeight = this.mIconHeight;
        int drawablePaddingHorizontal = drawablePadding;
        int drawablePaddingVertical = drawablePadding;
        if (this.mIconDirection == 1 || this.mIconDirection == 3) {
            drawableHeight = 0;
            drawablePaddingVertical = 0;
        }
        if (this.mIconDirection == 2 || this.mIconDirection == 4) {
            drawableWidth = 0;
            drawablePaddingHorizontal = 0;
        }
        float textWidth = TextViewUtils.get().getTextWidth((TextView)this.mView, drawableWidth, this.mPaddingLeft, this.mPaddingRight, drawablePaddingHorizontal);
        float bodyWidth = textWidth + (float)drawableWidth + (float)drawablePaddingHorizontal;
        float actualWidth = ((TextView)this.mView).getWidth() - (this.mPaddingLeft + this.mPaddingRight);
        int translateX = (int)(actualWidth - bodyWidth) / 2;
        if (translateX < 0) {
            translateX = 0;
        }
        float textHeight = TextViewUtils.get().getTextHeight((TextView)this.mView, drawableHeight, this.mPaddingTop, this.mPaddingBottom, drawablePaddingVertical);
        textHeight = Math.max(textHeight, (float)Math.max(this.mIconHeightLeft, this.mIconHeightRight));
        float bodyHeight = textHeight + (float)drawableHeight + (float)drawablePaddingVertical;
        float actualHeight = ((TextView)this.mView).getHeight() - (this.mPaddingTop + this.mPaddingBottom);
        int translateY = (int)(actualHeight - bodyHeight) / 2;
        if (translateY < 0) {
            translateY = 0;
        }
        if (!(paddingStr = "" + ((TextView)this.mView).getWidth() + ((TextView)this.mView).getHeight() + translateX + this.mPaddingLeft + translateY + this.mPaddingTop + translateX + this.mPaddingRight + translateY + this.mPaddingBottom).equals(this.mCacheSingleIconPaddingVale)) {
            this.mCacheSingleIconPaddingVale = paddingStr;
            ((TextView)this.mView).setPadding(translateX + this.mPaddingLeft, translateY + this.mPaddingTop, translateX + this.mPaddingRight, translateY + this.mPaddingBottom);
        }
    }

    private void setMultipleIconWithText() {
        String paddingStr;
        if (!this.mDrawableWithText || this.mView == null || ((TextView)this.mView).getWidth() == 0) {
            return;
        }
        int drawablePadding = ((TextView)this.mView).getCompoundDrawablePadding();
        int drawablePaddingHorizontal = 0;
        int drawablePaddingVertical = 0;
        if (this.mIconLeft != null) {
            drawablePaddingHorizontal += drawablePadding;
        }
        if (this.mIconRight != null) {
            drawablePaddingHorizontal += drawablePadding;
        }
        if (this.mIconTop != null) {
            drawablePaddingVertical += drawablePadding;
        }
        if (this.mIconBottom != null) {
            drawablePaddingVertical += drawablePadding;
        }
        int drawableWidthFinal = this.mIconWidthLeft + this.mIconWidthRight;
        int drawableHeightFinal = this.mIconHeightTop + this.mIconHeightBottom;
        int drawablePaddingVerticalFinal = drawablePaddingVertical;
        int drawablePaddingHorizontalFinal = drawablePaddingHorizontal;
        float textWidth = TextViewUtils.get().getTextWidth((TextView)this.mView, drawableWidthFinal, this.mPaddingLeft, this.mPaddingRight, drawablePaddingHorizontalFinal);
        float bodyWidth = textWidth + (float)drawableWidthFinal + (float)drawablePaddingHorizontalFinal;
        float actualWidth = ((TextView)this.mView).getWidth() - (this.mPaddingLeft + this.mPaddingRight);
        int translateX = (int)(actualWidth - bodyWidth) / 2;
        if (translateX < 0) {
            translateX = 0;
        }
        float textHeight = TextViewUtils.get().getTextHeight((TextView)this.mView, drawableHeightFinal, this.mPaddingTop, this.mPaddingBottom, drawablePaddingVerticalFinal);
        textHeight = Math.max(textHeight, (float)Math.max(this.mIconHeightLeft, this.mIconHeightRight));
        float bodyHeight = textHeight + (float)drawableHeightFinal + (float)drawablePaddingVerticalFinal;
        float actualHeight = ((TextView)this.mView).getHeight() - (this.mPaddingTop + this.mPaddingBottom);
        int translateY = (int)(actualHeight - bodyHeight) / 2;
        if (translateY < 0) {
            translateY = 0;
        }
        if (!(paddingStr = "" + ((TextView)this.mView).getWidth() + ((TextView)this.mView).getHeight() + translateX + this.mPaddingLeft + translateY + this.mPaddingTop + translateX + this.mPaddingRight + translateY + this.mPaddingBottom).equals(this.mCacheMultipleIconPaddingVale)) {
            this.mCacheMultipleIconPaddingVale = paddingStr;
            ((TextView)this.mView).setPadding(translateX + this.mPaddingLeft, translateY + this.mPaddingTop, translateX + this.mPaddingRight, translateY + this.mPaddingBottom);
        }
    }

    public RTextViewHelper setTextColorNormal(@ColorInt int textColor) {
        this.mTextColorNormal = textColor;
        this.updateTextColor();
        return this;
    }

    public RTextViewHelper setTextColorPressed(@ColorInt int textColor) {
        this.mTextColorPressed = textColor;
        this.mHasPressedTextColor = true;
        this.updateTextColor();
        return this;
    }

    public RTextViewHelper setTextColorUnable(@ColorInt int textColor) {
        this.mTextColorUnable = textColor;
        this.mHasUnableTextColor = true;
        this.updateTextColor();
        return this;
    }

    public RTextViewHelper setTextColorSelected(@ColorInt int textColor) {
        this.mTextColorSelected = textColor;
        this.mHasSelectedTextColor = true;
        this.updateTextColor();
        return this;
    }

    public RTextViewHelper setTextColor(@ColorInt int normal, @ColorInt int pressed, @ColorInt int unable, @ColorInt int selected, @ColorInt int checked) {
        this.mTextColorNormal = normal;
        this.mTextColorPressed = pressed;
        this.mTextColorUnable = unable;
        this.mTextColorSelected = selected;
        this.mTextColorChecked = checked;
        this.mHasPressedTextColor = true;
        this.mHasUnableTextColor = true;
        this.mHasSelectedTextColor = true;
        this.mHasCheckedTextColor = true;
        this.updateTextColor();
        return this;
    }

    public int getTextColorNormal() {
        return this.mTextColorNormal;
    }

    public int getTextColorPressed() {
        return this.mTextColorPressed;
    }

    public int getTextColorUnable() {
        return this.mTextColorUnable;
    }

    public int getTextColorSelected() {
        return this.mTextColorSelected;
    }

    public RTextViewHelper setTextColorChecked(@ColorInt int textColor) {
        this.mTextColorChecked = textColor;
        this.mHasCheckedTextColor = true;
        this.updateTextColor();
        return this;
    }

    public int getTextColorChecked() {
        return this.mTextColorChecked;
    }

    protected void setTextColor() {
        int[] colors = new int[]{this.mTextColorUnable, this.mTextColorPressed, this.mTextColorPressed, this.mTextColorChecked, this.mTextColorSelected, this.mTextColorNormal};
        this.mTextColorStateList = new ColorStateList(this.states, colors);
        ((TextView)this.mView).setTextColor(this.mTextColorStateList);
    }

    private void updateTextColor() {
        this.setupDefaultValue(false);
        this.setTextColor();
    }

    protected boolean isSingleDirection() {
        return this.mIconNormal != null || this.mIconPressed != null || this.mIconUnable != null || this.mIconSelected != null || this.mIconChecked != null;
    }

    @Override
    public void onGlobalLayout() {
        super.onGlobalLayout();
        this.mPaddingLeft = ((TextView)this.mView).getPaddingLeft();
        this.mPaddingRight = ((TextView)this.mView).getPaddingRight();
        this.mPaddingTop = ((TextView)this.mView).getPaddingTop();
        this.mPaddingBottom = ((TextView)this.mView).getPaddingBottom();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mIconLeft = !enabled && this.mIconUnableLeft != null ? this.mIconUnableLeft : this.mIconNormalLeft;
        this.mIconRight = !enabled && this.mIconUnableRight != null ? this.mIconUnableRight : this.mIconNormalRight;
        this.mIconTop = !enabled && this.mIconUnableTop != null ? this.mIconUnableTop : this.mIconNormalTop;
        this.mIconBottom = !enabled && this.mIconUnableBottom != null ? this.mIconUnableBottom : this.mIconNormalBottom;
        this.mIcon = !enabled && this.mIconUnable != null ? this.mIconUnable : this.mIconNormal;
        this.setIcon();
    }

    @Override
    public void setSelected(boolean selected) {
        if (!((TextView)this.mView).isEnabled()) {
            return;
        }
        this.mIconLeft = selected && this.mIconSelectedLeft != null ? this.mIconSelectedLeft : this.mIconNormalLeft;
        this.mIconRight = selected && this.mIconSelectedRight != null ? this.mIconSelectedRight : this.mIconNormalRight;
        this.mIconTop = selected && this.mIconSelectedTop != null ? this.mIconSelectedTop : this.mIconNormalTop;
        this.mIconBottom = selected && this.mIconSelectedBottom != null ? this.mIconSelectedBottom : this.mIconNormalBottom;
        this.mIcon = selected && this.mIconSelected != null ? this.mIconSelected : this.mIconNormal;
        this.setIcon();
    }

    @Override
    public void onTouchEvent(MotionEvent event) {
        if (!((TextView)this.mView).isEnabled()) {
            return;
        }
        if (this.isCompoundButtonChecked()) {
            return;
        }
        if (((TextView)this.mView).isSelected()) {
            return;
        }
        int action = event.getAction();
        switch (action) {
            case 1: 
            case 3: {
                this.mIconLeft = this.mIconNormalLeft;
                this.mIconRight = this.mIconNormalRight;
                this.mIconTop = this.mIconNormalTop;
                this.mIconBottom = this.mIconNormalBottom;
                this.mIcon = this.mIconNormal;
                this.setIcon();
                break;
            }
            case 0: {
                if (this.mIconPressedLeft != null) {
                    this.mIconLeft = this.mIconPressedLeft;
                }
                if (this.mIconPressedRight != null) {
                    this.mIconRight = this.mIconPressedRight;
                }
                if (this.mIconPressedTop != null) {
                    this.mIconTop = this.mIconPressedTop;
                }
                if (this.mIconPressedBottom != null) {
                    this.mIconBottom = this.mIconPressedBottom;
                }
                if (this.mIconPressed != null) {
                    this.mIcon = this.mIconPressed;
                }
                this.setIcon();
                break;
            }
            case 2: {
                int x = (int)event.getX();
                int y = (int)event.getY();
                if (!this.isOutsideView(x, y)) break;
                this.mIconLeft = this.mIconNormalLeft;
                this.mIconRight = this.mIconNormalRight;
                this.mIconTop = this.mIconNormalTop;
                this.mIconBottom = this.mIconNormalBottom;
                this.mIcon = this.mIconNormal;
                this.setIcon();
            }
        }
    }

    @Override
    public void drawIconWithText() {
        if (this.isSingleDirection()) {
            this.setSingleIconWithText();
        } else {
            this.setMultipleIconWithText();
        }
    }

    public void setChecked(boolean checked) {
        this.setIconLeft(checked ? this.mIconCheckedLeft : this.getIconNormalLeft());
        this.setIconRight(checked ? this.mIconCheckedRight : this.getIconNormalRight());
        this.setIconTop(checked ? this.mIconCheckedTop : this.getIconNormalTop());
        this.setIconBottom(checked ? this.mIconCheckedBottom : this.getIconNormalBottom());
        this.setIcon(checked ? this.mIconChecked : this.getIconNormal());
    }

    protected boolean isCompoundButtonChecked() {
        return false;
    }
}

