/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.helper;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import com.ruffian.library.widget.R;

@Deprecated
public class RImageViewHelper {
    private Drawable mIconNormal;
    private Drawable mIconPressed;
    private Drawable mIconUnable;
    private Drawable mIconSelected;
    private float mCorner = -1.0f;
    private float mCornerTopLeft = 0.0f;
    private float mCornerTopRight = 0.0f;
    private float mCornerBottomLeft = 0.0f;
    private float mCornerBottomRight = 0.0f;
    private float[] mCornerBorderRadii = new float[8];
    private float[] mCornerBitmapRadii = new float[8];
    private int mBorderWidth = 0;
    private int mBorderColor = -16777216;
    private boolean mIsNormal = true;
    private boolean mIsCircle = false;
    private final RectF mDrawableRect = new RectF();
    private final RectF mBorderRect = new RectF();
    private Paint mBitmapPaint;
    private Paint mBorderPaint;
    private Path mBitmapPath;
    protected int[][] states = new int[4][];
    private StateListDrawable mStateDrawable;
    private ImageView mView;
    private BitmapShader mBitmapShader;

    public RImageViewHelper(Context context, ImageView view, AttributeSet attrs) {
        this.mView = view;
        this.initAttributeSet(context, attrs);
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (context == null || attrs == null) {
            this.setup();
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RImageView);
        if (Build.VERSION.SDK_INT >= 21) {
            // empty if block
        }
        this.mIsCircle = a.getBoolean(R.styleable.RImageView_is_circle, false);
        this.mCorner = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius, -1);
        this.mCornerTopLeft = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_top_left, 0);
        this.mCornerTopRight = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_top_right, 0);
        this.mCornerBottomLeft = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_bottom_left, 0);
        this.mCornerBottomRight = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_bottom_right, 0);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.RImageView_border_width, 0);
        this.mBorderColor = a.getColor(R.styleable.RImageView_border_color, -16777216);
        a.recycle();
        if (this.mIconNormal == null) {
            this.mIconNormal = this.mView.getDrawable();
        }
        this.init();
        this.setup();
    }

    private void setup() {
        this.mStateDrawable = new StateListDrawable();
        if (this.mIconPressed == null) {
            this.mIconPressed = this.mIconNormal;
        }
        if (this.mIconUnable == null) {
            this.mIconUnable = this.mIconNormal;
        }
        if (this.mIconSelected == null) {
            this.mIconSelected = this.mIconNormal;
        }
        this.states[0] = new int[]{-16842910};
        this.states[1] = new int[]{16842919};
        this.states[2] = new int[]{0x10100A1};
        this.states[3] = new int[]{16842910};
        this.mStateDrawable.addState(this.states[0], this.mIconUnable);
        this.mStateDrawable.addState(this.states[1], this.mIconPressed);
        this.mStateDrawable.addState(this.states[2], this.mIconSelected);
        this.mStateDrawable.addState(this.states[3], this.mIconNormal);
        this.setIcon();
    }

    private void init() {
        this.updateCornerBorderRadii();
        this.updateCornerBitmapRadii();
        if (this.mIsCircle || this.mCorner > 0.0f || this.mCornerTopLeft != 0.0f || this.mCornerTopRight != 0.0f || this.mCornerBottomRight != 0.0f || this.mCornerBottomLeft != 0.0f) {
            this.mIsNormal = false;
        }
        if (this.mBorderPaint == null) {
            this.mBorderPaint = new Paint(1);
        }
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        if (this.mBitmapPaint == null) {
            this.mBitmapPaint = new Paint(1);
        }
        if (this.mBitmapPath == null) {
            this.mBitmapPath = new Path();
        }
    }

    public void onDraw(Canvas canvas) {
        this.drawBitmap(canvas);
        this.drawBorder(canvas);
    }

    private void drawBitmap(Canvas canvas) {
        Drawable drawable = this.mView.getDrawable();
        if (drawable == null) {
            return;
        }
        int bmpW = drawable.getIntrinsicWidth();
        int bmpH = drawable.getIntrinsicHeight();
        ImageView.ScaleType scaleType = this.mView.getScaleType();
        Bitmap bitmap = this.getBitmapFromDrawable(drawable, scaleType, bmpW, bmpH, this.getWidth(), this.getHeight());
        this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.updateCornerBitmapRadii();
        this.updateDrawableAndBorderRect();
        if (this.mIsCircle) {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min(this.mDrawableRect.width() / 2.0f, this.mDrawableRect.width() / 2.0f), this.mBitmapPaint);
        } else {
            this.mBitmapPath.reset();
            this.mBitmapPath.addRoundRect(this.mDrawableRect, this.mCornerBitmapRadii, Path.Direction.CCW);
            canvas.drawPath(this.mBitmapPath, this.mBitmapPaint);
        }
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable, ImageView.ScaleType scaleType, int bmpW, int bmpH, int w, int h) {
        Matrix matrix = this.mView.getMatrix();
        if (Build.VERSION.SDK_INT < 21) {
            matrix = new Matrix();
            matrix.set(this.mView.getMatrix());
        }
        int paddingLeft = this.mView.getPaddingLeft() + this.mBorderWidth;
        int paddingTop = this.mView.getPaddingTop() + this.mBorderWidth;
        int paddingRight = this.mView.getPaddingRight() + this.mBorderWidth;
        int paddingBottom = this.mView.getPaddingBottom() + this.mBorderWidth;
        float actualW = w - paddingLeft - paddingRight;
        float actualH = h - paddingTop - paddingBottom;
        float scaleW = actualW / (float)w;
        float scaleH = actualH / (float)h;
        Bitmap viewBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas viewCanvas = new Canvas(viewBitmap);
        viewCanvas.translate((float)paddingLeft, (float)paddingTop);
        viewCanvas.scale(scaleW, scaleH);
        float dx = 0.0f;
        float dy = 0.0f;
        switch (scaleType) {
            default: {
                matrix.setTranslate((float)Math.round((float)(w - bmpW) * 0.5f), (float)Math.round((float)(h - bmpH) * 0.5f));
                break;
            }
            case FIT_START: 
            case FIT_END: 
            case FIT_CENTER: {
                RectF mTempSrc = new RectF(0.0f, 0.0f, (float)bmpW, (float)bmpH);
                RectF mTempDst = new RectF(0.0f, 0.0f, (float)w, (float)h);
                matrix.setRectToRect(mTempSrc, mTempDst, RImageViewHelper.scaleTypeToScaleToFit(scaleType));
                break;
            }
            case FIT_XY: {
                drawable.setBounds(0, 0, w, h);
                matrix = null;
                break;
            }
            case CENTER_CROP: {
                float scale;
                if (bmpW * h > w * bmpH) {
                    scale = (float)h / (float)bmpH;
                    dx = ((float)w - (float)bmpW * scale) * 0.5f;
                } else {
                    scale = (float)w / (float)bmpW;
                    dy = ((float)h - (float)bmpH * scale) * 0.5f;
                }
                matrix.setScale(scale, scale);
                matrix.postTranslate((float)Math.round(dx), (float)Math.round(dy));
                break;
            }
            case CENTER_INSIDE: {
                float scale = bmpW <= w && bmpH <= h ? 1.0f : Math.min((float)w / (float)bmpW, (float)h / (float)bmpH);
                dx = Math.round(((float)w - (float)bmpW * scale) * 0.5f);
                dy = Math.round(((float)h - (float)bmpH * scale) * 0.5f);
                matrix.setScale(scale, scale);
                matrix.postTranslate(dx, dy);
                break;
            }
            case MATRIX: {
                if (!matrix.isIdentity()) break;
                matrix = null;
            }
        }
        if (matrix != null) {
            viewCanvas.concat(matrix);
        }
        drawable.draw(viewCanvas);
        return viewBitmap;
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ImageView.ScaleType st) {
        switch (st) {
            case FIT_XY: {
                return Matrix.ScaleToFit.FILL;
            }
            case FIT_START: {
                return Matrix.ScaleToFit.START;
            }
            case FIT_END: {
                return Matrix.ScaleToFit.END;
            }
            case FIT_CENTER: {
                return Matrix.ScaleToFit.CENTER;
            }
        }
        return Matrix.ScaleToFit.CENTER;
    }

    private void drawBorder(Canvas canvas) {
        if (this.mBorderWidth > 0) {
            this.mBorderPaint.setColor(this.mBorderColor);
            this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
            if (this.mIsCircle) {
                float borderRadiusX = (this.mBorderRect.width() - (float)this.mBorderWidth) / 2.0f;
                float borderRadiusY = (this.mBorderRect.height() - (float)this.mBorderWidth) / 2.0f;
                canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min(borderRadiusX, borderRadiusY), this.mBorderPaint);
            } else {
                this.updateCornerBorderRadii();
                Path path = new Path();
                path.addRoundRect(this.mBorderRect, this.mCornerBorderRadii, Path.Direction.CW);
                canvas.drawPath(path, this.mBorderPaint);
            }
        }
    }

    private void updateDrawableAndBorderRect() {
        float half = (float)this.mBorderWidth / 2.0f;
        if (this.mIsCircle) {
            float minRect = Math.min(this.getWidth(), this.getHeight());
            this.mBorderRect.set(half, half, (float)this.getWidth() - half, (float)this.getHeight() - half);
            this.mDrawableRect.set(this.mBorderRect.left + half, this.mBorderRect.top + half, minRect - half, minRect - half);
        } else {
            this.mBorderRect.set(half, half, (float)this.getWidth() - half, (float)this.getHeight() - half);
            this.mDrawableRect.set(this.mBorderRect.left + half, this.mBorderRect.top + half, this.mBorderRect.right - half, this.mBorderRect.bottom - half);
        }
    }

    private void updateCornerBitmapRadii() {
        if (this.mCorner >= 0.0f) {
            for (int i = 0; i < this.mCornerBitmapRadii.length; ++i) {
                this.mCornerBitmapRadii[i] = this.mCorner;
            }
            return;
        }
        if (this.mCorner < 0.0f) {
            this.mCornerBitmapRadii[0] = this.mCornerTopLeft;
            this.mCornerBitmapRadii[1] = this.mCornerTopLeft;
            this.mCornerBitmapRadii[2] = this.mCornerTopRight;
            this.mCornerBitmapRadii[3] = this.mCornerTopRight;
            this.mCornerBitmapRadii[4] = this.mCornerBottomRight;
            this.mCornerBitmapRadii[5] = this.mCornerBottomRight;
            this.mCornerBitmapRadii[6] = this.mCornerBottomLeft;
            this.mCornerBitmapRadii[7] = this.mCornerBottomLeft;
            return;
        }
    }

    private void updateCornerBorderRadii() {
        if (this.mCorner >= 0.0f) {
            for (int i = 0; i < this.mCornerBorderRadii.length; ++i) {
                this.mCornerBorderRadii[i] = this.mCorner == 0.0f ? this.mCorner : this.mCorner + (float)this.mBorderWidth;
            }
            return;
        }
        if (this.mCorner < 0.0f) {
            this.mCornerBorderRadii[0] = this.mCornerTopLeft == 0.0f ? this.mCornerTopLeft : this.mCornerTopLeft + (float)this.mBorderWidth;
            this.mCornerBorderRadii[1] = this.mCornerTopLeft == 0.0f ? this.mCornerTopLeft : this.mCornerTopLeft + (float)this.mBorderWidth;
            this.mCornerBorderRadii[2] = this.mCornerTopRight == 0.0f ? this.mCornerTopRight : this.mCornerTopRight + (float)this.mBorderWidth;
            this.mCornerBorderRadii[3] = this.mCornerTopRight == 0.0f ? this.mCornerTopRight : this.mCornerTopRight + (float)this.mBorderWidth;
            this.mCornerBorderRadii[4] = this.mCornerBottomRight == 0.0f ? this.mCornerBottomRight : this.mCornerBottomRight + (float)this.mBorderWidth;
            this.mCornerBorderRadii[5] = this.mCornerBottomRight == 0.0f ? this.mCornerBottomRight : this.mCornerBottomRight + (float)this.mBorderWidth;
            this.mCornerBorderRadii[6] = this.mCornerBottomLeft == 0.0f ? this.mCornerBottomLeft : this.mCornerBottomLeft + (float)this.mBorderWidth;
            this.mCornerBorderRadii[7] = this.mCornerBottomLeft == 0.0f ? this.mCornerBottomLeft : this.mCornerBottomLeft + (float)this.mBorderWidth;
            return;
        }
    }

    private int getWidth() {
        return this.mView.getWidth();
    }

    private int getHeight() {
        return this.mView.getHeight();
    }

    private void invalidate() {
        this.mView.invalidate();
    }

    public RImageViewHelper setIconNormal(Drawable icon) {
        this.mIconNormal = icon;
        if (this.mIconPressed == null) {
            this.mIconPressed = this.mIconNormal;
        }
        if (this.mIconUnable == null) {
            this.mIconUnable = this.mIconNormal;
        }
        if (this.mIconSelected == null) {
            this.mIconSelected = this.mIconNormal;
        }
        this.setIcon();
        return this;
    }

    public Drawable getIconNormal() {
        return this.mIconNormal;
    }

    public RImageViewHelper setIconPressed(Drawable icon) {
        this.mIconPressed = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconPressed() {
        return this.mIconPressed;
    }

    public RImageViewHelper setIconUnable(Drawable icon) {
        this.mIconUnable = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconUnable() {
        return this.mIconUnable;
    }

    public RImageViewHelper setIconSelected(Drawable icon) {
        this.mIconSelected = icon;
        this.setIcon();
        return this;
    }

    public Drawable getIconSelected() {
        return this.mIconSelected;
    }

    private void setIcon() {
        this.mView.setImageDrawable((Drawable)this.mStateDrawable);
        this.mView.invalidate();
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public RImageViewHelper setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.invalidate();
        return this;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public RImageViewHelper setBorderColor(@ColorInt int borderColor) {
        this.mBorderColor = borderColor;
        this.invalidate();
        return this;
    }

    public float getCorner() {
        return this.mCorner;
    }

    public RImageViewHelper setCorner(float corner) {
        this.mCorner = corner;
        this.init();
        this.invalidate();
        return this;
    }

    public float getCornerTopLeft() {
        return this.mCornerTopLeft;
    }

    public RImageViewHelper setCornerTopLeft(float cornerTopLeft) {
        this.mCorner = -1.0f;
        this.mCornerTopLeft = cornerTopLeft;
        this.init();
        this.invalidate();
        return this;
    }

    public float getCornerTopRight() {
        return this.mCornerTopRight;
    }

    public RImageViewHelper setCornerTopRight(float cornerTopRight) {
        this.mCorner = -1.0f;
        this.mCornerTopRight = cornerTopRight;
        this.init();
        this.invalidate();
        return this;
    }

    public float getCornerBottomLeft() {
        return this.mCornerBottomLeft;
    }

    public RImageViewHelper setCornerBottomLeft(float cornerBottomLeft) {
        this.mCorner = -1.0f;
        this.mCornerBottomLeft = cornerBottomLeft;
        this.init();
        this.invalidate();
        return this;
    }

    public float getCornerBottomRight() {
        return this.mCornerBottomRight;
    }

    public RImageViewHelper setCornerBottomRight(float cornerBottomRight) {
        this.mCorner = -1.0f;
        this.mCornerBottomRight = cornerBottomRight;
        this.init();
        this.invalidate();
        return this;
    }

    public RImageViewHelper setCorner(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.mCorner = -1.0f;
        this.mCornerTopLeft = topLeft;
        this.mCornerTopRight = topRight;
        this.mCornerBottomRight = bottomRight;
        this.mCornerBottomLeft = bottomLeft;
        this.init();
        this.invalidate();
        return this;
    }

    public boolean isNormal() {
        return this.mIsNormal;
    }
}

