/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.struct;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class BlockLinkedList<E>
extends AbstractList<E> {
    private int length;
    private int modCount;
    private final int blockSize;
    private Block head;
    private final List<Cache> caches;
    private int foundIndex;
    private Block foundBlock;
    private static final int CACHE_COUNT = 8;
    private static final int CACHE_SWITCH = 30;

    public BlockLinkedList() {
        this(16);
    }

    public BlockLinkedList(int blockSize) {
        this.blockSize = blockSize;
        if (blockSize <= 4) {
            throw new IllegalArgumentException("block size must be bigger than 4");
        }
        this.length = 0;
        this.modCount = 0;
        this.head = new Block();
        this.caches = new ArrayList<Cache>(10);
    }

    private void findBlock1(int index) {
        int distance = index;
        int usedNo = -1;
        Block fromBlock = this.head;
        for (int i = 0; i < this.caches.size(); ++i) {
            Cache c = this.caches.get(i);
            if (c.indexOfStart >= index || index - c.indexOfStart >= distance) continue;
            distance = index - c.indexOfStart;
            fromBlock = c.block;
            usedNo = i;
        }
        if (usedNo != -1) {
            Collections.swap(this.caches, 0, usedNo);
        }
        int crossCount = 0;
        while (distance >= fromBlock.size() && fromBlock.next != null) {
            distance -= fromBlock.size();
            fromBlock = fromBlock.next;
            ++crossCount;
        }
        if (crossCount >= 30) {
            this.caches.add(this.cache(index - distance, fromBlock));
        }
        if (this.caches.size() > 8) {
            this.caches.remove(this.caches.size() - 1);
        }
        this.foundIndex = distance;
        this.foundBlock = fromBlock;
    }

    private void invalidateCacheFrom(int index) {
        for (int i = 0; i < this.caches.size(); ++i) {
            if (this.caches.get((int)i).indexOfStart < index) continue;
            this.caches.remove(i);
            --i;
        }
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size()) {
            throw new ArrayIndexOutOfBoundsException("index = " + index + ", length = " + this.size());
        }
        this.findBlock1(index);
        this.invalidateCacheFrom(index);
        Block block = this.foundBlock;
        for (index = this.foundIndex; index > block.size() && block.next != null; index -= block.size()) {
            block = block.next;
        }
        block.add(index, element);
        ++this.length;
        if (block.size() > this.blockSize) {
            block.separate();
        }
        ++this.modCount;
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("index = " + index + ", length = " + this.size());
        }
        int backup = index;
        Block previous = null;
        Block block = this.head;
        while (index >= block.size()) {
            index -= block.size();
            previous = block;
            block = block.next;
        }
        Object removedValue = block.remove(index);
        this.invalidateCacheFrom(backup - index);
        if (block.size() == 0 && previous != null) {
            previous.next = block.next;
        } else if (block.size() < this.blockSize / 4 && previous != null && previous.size() + block.size() < this.blockSize / 2) {
            previous.next = block.next;
            System.arraycopy(block.data, 0, previous.data, previous.size, block.size);
            Block block2 = previous;
            block2.size = block2.size + block.size;
        }
        ++this.modCount;
        --this.length;
        return (E)removedValue;
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("index = " + index + ", length = " + this.size());
        }
        this.findBlock1(index);
        return (E)this.foundBlock.set(this.foundIndex, element);
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("index = " + index + ", length = " + this.size());
        }
        this.findBlock1(index);
        return (E)this.foundBlock.get(this.foundIndex);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        Block previous = null;
        Block block = this.head;
        while (fromIndex >= block.size()) {
            fromIndex -= block.size();
            toIndex -= block.size();
            previous = block;
            block = block.next;
        }
        int deleteLength = toIndex - fromIndex;
        int begin = fromIndex;
        while (deleteLength > 0) {
            if (begin == 0 && deleteLength >= block.size()) {
                if (previous != null) {
                    previous.next = block.next;
                }
                deleteLength -= block.size();
                block.size = 0;
                block = block.next;
                continue;
            }
            int end = Math.min(block.size(), begin + deleteLength);
            block.remove(begin, end);
            deleteLength -= end - begin;
            previous = block;
            block = block.next;
        }
        this.length -= toIndex - fromIndex;
    }

    @Override
    public void clear() {
        this.head = new Block();
        this.length = 0;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator(0);
    }

    public Iterator<E> iterator(int startIndex) {
        if (startIndex < 0 || startIndex > this.size()) {
            throw new IndexOutOfBoundsException("index = " + startIndex + ", length = " + this.size());
        }
        return new BlockIterator(startIndex);
    }

    private Cache cache(int index, Block block) {
        Cache c = new Cache();
        c.indexOfStart = index;
        c.block = block;
        return c;
    }

    private class BlockIterator
    implements Iterator<E> {
        private int localModCount;
        private Block block;
        private int index;
        private int indexInBlock;
        private boolean removeAvailable;

        BlockIterator(int startIndex) {
            this.localModCount = BlockLinkedList.this.modCount;
            this.index = startIndex - 1;
            this.block = BlockLinkedList.this.head;
            while (startIndex >= this.block.size()) {
                startIndex -= this.block.size();
                this.block = this.block.next;
            }
            this.indexInBlock = startIndex - 1;
            this.removeAvailable = false;
        }

        private void checkConcurrentMod() {
            if (this.localModCount != BlockLinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < BlockLinkedList.this.size();
        }

        @Override
        public E next() {
            this.checkConcurrentMod();
            if (this.hasNext()) {
                while (this.indexInBlock + 1 >= this.block.size()) {
                    this.indexInBlock = -1;
                    this.block = this.block.next;
                }
                Object value = this.block.get(++this.indexInBlock);
                ++this.index;
                this.removeAvailable = true;
                return value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.checkConcurrentMod();
            if (!this.removeAvailable) {
                throw new IllegalStateException("next() has not been called");
            }
            this.block.remove(this.indexInBlock);
            BlockLinkedList.this.modCount++;
            ++this.localModCount;
            --this.indexInBlock;
            this.removeAvailable = false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
    }

    private class Cache {
        public Block block;
        public int indexOfStart;

        private Cache() {
        }
    }

    private class Block {
        private int size;
        private final Object[] data;
        private Block next;

        public int size() {
            return this.size;
        }

        public Block() {
            this.data = new Object[BlockLinkedList.this.blockSize + 5];
            this.size = 0;
        }

        public void add(int index, Object element) {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
            this.data[index] = element;
            ++this.size;
        }

        public Object set(int index, Object element) {
            Object old = this.data[index];
            this.data[index] = element;
            return old;
        }

        public Object get(int index) {
            return this.data[index];
        }

        public Object remove(int index) {
            Object oldValue = this.data[index];
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
            --this.size;
            return oldValue;
        }

        public void remove(int start, int end) {
            System.arraycopy(this.data, end, this.data, start, this.size - end);
            this.size -= end - start;
        }

        public void separate() {
            Block oldNext = this.next;
            Block newNext = new Block();
            int divPoint = BlockLinkedList.this.blockSize / 2;
            System.arraycopy(this.data, divPoint, newNext.data, 0, this.size - divPoint);
            newNext.size = this.size - divPoint;
            this.size = divPoint;
            this.next = newNext;
            newNext.next = oldNext;
        }
    }
}

