/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiteshsondhi88.libffmpeg;

import com.github.hiteshsondhi88.libffmpeg.Util;

class CommandResult {
    final String output;
    final boolean success;

    CommandResult(boolean success, String output) {
        this.success = success;
        this.output = output;
    }

    static CommandResult getDummyFailureResponse() {
        return new CommandResult(false, "");
    }

    static CommandResult getOutputFromProcess(Process process) {
        String output = CommandResult.success(process.exitValue()) ? Util.convertInputStreamToString(process.getInputStream()) : Util.convertInputStreamToString(process.getErrorStream());
        return new CommandResult(CommandResult.success(process.exitValue()), output);
    }

    static boolean success(Integer exitValue) {
        return exitValue != null && exitValue == 0;
    }
}

