/*
 * Decompiled with CFR 0.152.
 */
package cafe.adriel.androidaudioconverter;

import android.content.Context;
import cafe.adriel.androidaudioconverter.callback.IConvertCallback;
import cafe.adriel.androidaudioconverter.callback.ILoadCallback;
import cafe.adriel.androidaudioconverter.model.AudioFormat;
import com.github.hiteshsondhi88.libffmpeg.FFmpeg;
import com.github.hiteshsondhi88.libffmpeg.FFmpegExecuteResponseHandler;
import com.github.hiteshsondhi88.libffmpeg.FFmpegLoadBinaryResponseHandler;
import java.io.File;
import java.io.IOException;

public class AndroidAudioConverter {
    private static boolean loaded;
    private Context context;
    private File audioFile;
    private AudioFormat format;
    private IConvertCallback callback;

    private AndroidAudioConverter(Context context) {
        this.context = context;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void load(Context context, final ILoadCallback callback) {
        try {
            FFmpeg.getInstance((Context)context).loadBinary(new FFmpegLoadBinaryResponseHandler(){

                public void onStart() {
                }

                public void onSuccess() {
                    loaded = true;
                    callback.onSuccess();
                }

                public void onFailure() {
                    loaded = false;
                    callback.onFailure(new Exception("Failed to loaded FFmpeg lib"));
                }

                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            loaded = false;
            callback.onFailure(e);
        }
    }

    public static AndroidAudioConverter with(Context context) {
        return new AndroidAudioConverter(context);
    }

    public AndroidAudioConverter setFile(File originalFile) {
        this.audioFile = originalFile;
        return this;
    }

    public AndroidAudioConverter setFormat(AudioFormat format) {
        this.format = format;
        return this;
    }

    public AndroidAudioConverter setCallback(IConvertCallback callback) {
        this.callback = callback;
        return this;
    }

    public void convert() {
        if (!AndroidAudioConverter.isLoaded()) {
            this.callback.onFailure(new Exception("FFmpeg not loaded"));
            return;
        }
        if (this.audioFile == null || !this.audioFile.exists()) {
            this.callback.onFailure(new IOException("File not exists"));
            return;
        }
        if (!this.audioFile.canRead()) {
            this.callback.onFailure(new IOException("Can't read the file. Missing permission?"));
            return;
        }
        final File convertedFile = AndroidAudioConverter.getConvertedFile(this.audioFile, this.format);
        String[] cmd = new String[]{"-y", "-i", this.audioFile.getPath(), convertedFile.getPath()};
        try {
            FFmpeg.getInstance((Context)this.context).execute(cmd, new FFmpegExecuteResponseHandler(){

                public void onStart() {
                }

                public void onProgress(String message) {
                }

                public void onSuccess(String message) {
                    AndroidAudioConverter.this.callback.onSuccess(convertedFile);
                }

                public void onFailure(String message) {
                    AndroidAudioConverter.this.callback.onFailure(new IOException(message));
                }

                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            this.callback.onFailure(e);
        }
    }

    private static File getConvertedFile(File originalFile, AudioFormat format) {
        String[] f = originalFile.getPath().split("\\.");
        String filePath = originalFile.getPath().replace(f[f.length - 1], format.getFormat());
        return new File(filePath);
    }
}

