/*
 * Decompiled with CFR 0.152.
 */
package view_component.lib_android.com.view_component.base_view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import view_component.lib_android.com.view_component.base_view.ComponentDelegate;
import view_component.lib_android.com.view_component.base_view.ControllerComponent;
import view_component.lib_android.com.view_component.base_view.ControllerLifeCycle;
import view_component.lib_android.com.view_component.base_view.ViewComponent;

public class ComponentDelegateImpl<VC extends ViewComponent, CC extends ControllerComponent<VC>>
implements ComponentDelegate<VC, CC>,
ControllerLifeCycle<VC> {
    private VC viewComponent;
    private CC controllerComponent;
    private final ComponentDelegate<VC, CC> componentDelegate;

    @NonNull
    public static <VC extends ViewComponent, CC extends ControllerComponent<VC>> ComponentDelegateImpl<VC, CC> create(@NonNull ComponentDelegate<VC, CC> componentDelegate, @NonNull Context context) {
        return new ComponentDelegateImpl<VC, CC>(componentDelegate, context);
    }

    private ComponentDelegateImpl(ComponentDelegate<VC, CC> componentDelegate, Context context) {
        this.componentDelegate = componentDelegate;
        this.viewComponent = this.createViewComponent(LayoutInflater.from((Context)context));
        this.controllerComponent = this.createControllerComponent();
        this.onCreate(this.viewComponent);
    }

    @Override
    public VC getViewComponent() {
        return this.viewComponent;
    }

    @Override
    public CC getControllerComponent() {
        return this.controllerComponent;
    }

    @Override
    @NonNull
    public VC createViewComponent(@NonNull LayoutInflater inflater) {
        VC component = this.componentDelegate.createViewComponent(inflater);
        this.assertComponent(component, "createViewComponent method can't return null");
        return component;
    }

    @Override
    @NonNull
    public CC createControllerComponent() {
        CC component = this.componentDelegate.createControllerComponent();
        this.assertComponent(component, "createControllerComponent method can't return null");
        return component;
    }

    @Override
    public void onCreate(@NonNull VC viewComponent) {
        ((ControllerComponent)this.controllerComponent).onCreate(viewComponent);
    }

    @Override
    public void onDestroy() {
        ((ControllerComponent)this.controllerComponent).onDestroy();
        this.controllerComponent = null;
        this.viewComponent = null;
    }

    private void assertComponent(Object component, String msg) {
        if (component == null) {
            throw new NullPointerException(this.getCallerClassName() + msg);
        }
    }

    private String getCallerClassName() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        String packageName = this.getClass().getPackage().getName();
        for (StackTraceElement aStackTrace : stackTrace) {
            if (aStackTrace.getClassName().contains(packageName)) continue;
            return aStackTrace.getClassName() + ":";
        }
        return "";
    }
}

