/*
 * Decompiled with CFR 0.152.
 */
package section_layout.widget.custom.android.com.sectionlayout.distributive_section_layout;

import android.view.View;
import android.view.ViewGroup;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayoutViewComponent;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayoutViewControllerComponent;

public class DistributiveSectionLayoutControllerComponent<D>
extends SectionLayoutViewControllerComponent<D> {
    private boolean willDistributeEvenly;

    void distributeEvenly(boolean willDistributeEvenly) {
        this.willDistributeEvenly = willDistributeEvenly;
    }

    void measureDistribute(int widthMeasureSpec) {
        SectionLayoutViewComponent viewComponent = (SectionLayoutViewComponent)this.getViewComponent();
        ViewGroup parent = viewComponent.getRootViewGroup();
        if (parent.getChildCount() > 0) {
            int maxWidth = 0;
            if (this.isWidthSetToMatchParent(parent)) {
                if (this.willDistributeEvenly) {
                    maxWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) / parent.getChildCount();
                    this.setChildesWidth(maxWidth, parent);
                } else {
                    View child;
                    int i;
                    double maxLength = 0.0;
                    for (i = 0; i < parent.getChildCount(); ++i) {
                        child = parent.getChildAt(i);
                        maxLength += (double)child.getMeasuredWidth();
                    }
                    double k = (double)View.MeasureSpec.getSize((int)widthMeasureSpec) / maxLength;
                    for (i = 0; i < parent.getChildCount(); ++i) {
                        child = parent.getChildAt(i);
                        child.getLayoutParams().width = (int)((double)child.getMeasuredWidth() * k);
                    }
                }
            } else if (this.isWidthSetToWrapContent(parent)) {
                if (this.willDistributeEvenly) {
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        int nextChildWidth = parent.getChildAt(i).getMeasuredWidth();
                        maxWidth = Math.max(maxWidth, nextChildWidth);
                        this.setChildesWidth(maxWidth, parent);
                    }
                }
            } else if (this.willDistributeEvenly) {
                maxWidth = parent.getLayoutParams().width / parent.getChildCount();
                this.setChildesWidth(maxWidth, parent);
            }
        }
    }

    private void setChildesWidth(int maxWidth, ViewGroup parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            parent.getChildAt((int)i).getLayoutParams().width = maxWidth;
        }
    }

    private boolean isWidthSetToMatchParent(ViewGroup parent) {
        return -1 == parent.getLayoutParams().width;
    }

    private boolean isWidthSetToWrapContent(ViewGroup parent) {
        return -2 == parent.getLayoutParams().width;
    }
}

