/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.BaseTransformable;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.WhereBase;
import com.raizlabs.android.dbflow.structure.BaseModel;

public class Set<TModel>
extends BaseTransformable<TModel>
implements WhereBase<TModel> {
    private OperatorGroup operatorGroup;
    private Query update;

    public Set(@NonNull Query update, @NonNull Class<TModel> table) {
        super(table);
        this.update = update;
        this.operatorGroup = OperatorGroup.nonGroupingClause().setAllCommaSeparated(true);
    }

    @NonNull
    public Set<TModel> conditions(SQLOperator ... conditions) {
        this.operatorGroup.andAll(conditions);
        return this;
    }

    @NonNull
    public Set<TModel> conditionValues(@NonNull ContentValues contentValues) {
        SqlUtils.addContentValues(contentValues, this.operatorGroup);
        return this;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.update.getQuery()).append((Object)"SET ").append((Object)this.operatorGroup.getQuery()).appendSpace();
        return queryBuilder.getQuery();
    }

    @Override
    @NonNull
    public Query getQueryBuilderBase() {
        return this.update;
    }

    @Override
    @NonNull
    public BaseModel.Action getPrimaryAction() {
        return BaseModel.Action.UPDATE;
    }
}

