/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.config;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.queriable.ListModelLoader;
import com.raizlabs.android.dbflow.sql.queriable.SingleModelLoader;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;

public final class TableConfig<TModel> {
    private final Class<TModel> tableClass;
    private final ModelSaver<TModel> modelSaver;
    private final SingleModelLoader<TModel> singleModelLoader;
    private final ListModelLoader<TModel> listModelLoader;

    public static <TModel> Builder<TModel> builder(Class<TModel> tableClass) {
        return new Builder<TModel>(tableClass);
    }

    TableConfig(Builder<TModel> builder) {
        this.tableClass = builder.tableClass;
        this.modelSaver = builder.modelAdapterModelSaver;
        this.singleModelLoader = builder.singleModelLoader;
        this.listModelLoader = builder.listModelLoader;
    }

    @NonNull
    public Class<?> tableClass() {
        return this.tableClass;
    }

    @Nullable
    public ModelSaver<TModel> modelSaver() {
        return this.modelSaver;
    }

    @Nullable
    public ListModelLoader<TModel> listModelLoader() {
        return this.listModelLoader;
    }

    @Nullable
    public SingleModelLoader<TModel> singleModelLoader() {
        return this.singleModelLoader;
    }

    public static final class Builder<TModel> {
        final Class<TModel> tableClass;
        ModelSaver<TModel> modelAdapterModelSaver;
        SingleModelLoader<TModel> singleModelLoader;
        ListModelLoader<TModel> listModelLoader;

        public Builder(@NonNull Class<TModel> tableClass) {
            this.tableClass = tableClass;
        }

        @NonNull
        public Builder<TModel> modelAdapterModelSaver(@NonNull ModelSaver<TModel> modelSaver) {
            this.modelAdapterModelSaver = modelSaver;
            return this;
        }

        @NonNull
        public Builder<TModel> singleModelLoader(@NonNull SingleModelLoader<TModel> singleModelLoader) {
            this.singleModelLoader = singleModelLoader;
            return this;
        }

        @NonNull
        public Builder<TModel> listModelLoader(@NonNull ListModelLoader<TModel> listModelLoader) {
            this.listModelLoader = listModelLoader;
            return this;
        }

        @NonNull
        public TableConfig build() {
            return new TableConfig(this);
        }
    }
}

