/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.list;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.list.FlowCursorIterator;
import com.raizlabs.android.dbflow.list.FlowCursorList;
import com.raizlabs.android.dbflow.list.IFlowCursorIterator;
import com.raizlabs.android.dbflow.runtime.FlowContentObserver;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.QueryTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class FlowQueryList<TModel>
extends FlowContentObserver
implements List<TModel>,
IFlowCursorIterator<TModel> {
    private static final Handler REFRESH_HANDLER = new Handler(Looper.myLooper());
    private final FlowCursorList<TModel> internalCursorList;
    private final Transaction.Success successCallback;
    private final Transaction.Error errorCallback;
    private boolean transact = false;
    private boolean changeInTransaction = false;
    private boolean pendingRefresh = false;
    private final ProcessModelTransaction.ProcessModel<TModel> saveModel = new ProcessModelTransaction.ProcessModel<TModel>(){

        @Override
        public void processModel(TModel model, DatabaseWrapper wrapper) {
            FlowQueryList.this.getModelAdapter().save(model);
        }
    };
    private final ProcessModelTransaction.ProcessModel<TModel> updateModel = new ProcessModelTransaction.ProcessModel<TModel>(){

        @Override
        public void processModel(TModel model, DatabaseWrapper wrapper) {
            FlowQueryList.this.getModelAdapter().update(model);
        }
    };
    private final ProcessModelTransaction.ProcessModel<TModel> deleteModel = new ProcessModelTransaction.ProcessModel<TModel>(){

        @Override
        public void processModel(TModel model, DatabaseWrapper wrapper) {
            FlowQueryList.this.getModelAdapter().delete(model);
        }
    };
    private final Transaction.Error internalErrorCallback = new Transaction.Error(){

        @Override
        public void onError(@NonNull Transaction transaction, @NonNull Throwable error) {
            if (FlowQueryList.this.errorCallback != null) {
                FlowQueryList.this.errorCallback.onError(transaction, error);
            }
        }
    };
    private final Transaction.Success internalSuccessCallback = new Transaction.Success(){

        @Override
        public void onSuccess(@NonNull Transaction transaction) {
            if (!FlowQueryList.this.isInTransaction) {
                FlowQueryList.this.refreshAsync();
            } else {
                FlowQueryList.this.changeInTransaction = true;
            }
            if (FlowQueryList.this.successCallback != null) {
                FlowQueryList.this.successCallback.onSuccess(transaction);
            }
        }
    };
    private final Runnable refreshRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            6 var1_1 = this;
            synchronized (var1_1) {
                FlowQueryList.this.pendingRefresh = false;
            }
            FlowQueryList.this.refresh();
        }
    };

    private FlowQueryList(Builder<TModel> builder) {
        super("com.dbflow.authority");
        this.transact = ((Builder)builder).transact;
        this.changeInTransaction = ((Builder)builder).changeInTransaction;
        this.successCallback = ((Builder)builder).success;
        this.errorCallback = ((Builder)builder).error;
        this.internalCursorList = new FlowCursorList.Builder(((Builder)builder).table).cursor(((Builder)builder).cursor).cacheModels(((Builder)builder).cacheModels).modelQueriable(((Builder)builder).modelQueriable).modelCache(((Builder)builder).modelCache).build();
    }

    public void registerForContentChanges(@NonNull Context context) {
        super.registerForContentChanges(context, this.internalCursorList.table());
    }

    public void addOnCursorRefreshListener(@NonNull FlowCursorList.OnCursorRefreshListener<TModel> onCursorRefreshListener) {
        this.internalCursorList.addOnCursorRefreshListener(onCursorRefreshListener);
    }

    public void removeOnCursorRefreshListener(@NonNull FlowCursorList.OnCursorRefreshListener<TModel> onCursorRefreshListener) {
        this.internalCursorList.removeOnCursorRefreshListener(onCursorRefreshListener);
    }

    @Override
    public void registerForContentChanges(Context context, Class<?> table) {
        throw new RuntimeException("This method is not to be used in the FlowQueryList. We should only ever receive notifications for one class here. Call registerForContentChanges(Context) instead");
    }

    @Override
    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        if (!this.isInTransaction) {
            this.refreshAsync();
        } else {
            this.changeInTransaction = true;
        }
    }

    @Override
    @TargetApi(value=16)
    public void onChange(boolean selfChange, Uri uri) {
        super.onChange(selfChange, uri);
        if (!this.isInTransaction) {
            this.refreshAsync();
        } else {
            this.changeInTransaction = true;
        }
    }

    @NonNull
    public List<TModel> getCopy() {
        return this.internalCursorList.getAll();
    }

    @NonNull
    public FlowCursorList<TModel> cursorList() {
        return this.internalCursorList;
    }

    @Nullable
    public Transaction.Error error() {
        return this.errorCallback;
    }

    @Nullable
    public Transaction.Success success() {
        return this.successCallback;
    }

    public boolean changeInTransaction() {
        return this.changeInTransaction;
    }

    public boolean transact() {
        return this.transact;
    }

    @NonNull
    ModelAdapter<TModel> getModelAdapter() {
        return this.internalCursorList.getModelAdapter();
    }

    @NonNull
    InstanceAdapter<TModel> getInstanceAdapter() {
        return this.internalCursorList.getInstanceAdapter();
    }

    @NonNull
    public Builder<TModel> newBuilder() {
        return new Builder(this.internalCursorList).success(this.successCallback).error(this.errorCallback).changeInTransaction(this.changeInTransaction).transact(this.transact);
    }

    public void refresh() {
        this.internalCursorList.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAsync() {
        FlowQueryList flowQueryList = this;
        synchronized (flowQueryList) {
            if (this.pendingRefresh) {
                return;
            }
            this.pendingRefresh = true;
        }
        REFRESH_HANDLER.post(this.refreshRunnable);
    }

    @Override
    public void endTransactionAndNotify() {
        if (this.changeInTransaction) {
            this.changeInTransaction = false;
            this.refresh();
        }
        super.endTransactionAndNotify();
    }

    @Override
    public void add(int location, @Nullable TModel model) {
        this.add(model);
    }

    @Override
    public boolean add(@Nullable TModel model) {
        if (model != null) {
            Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder<TModel>(this.saveModel).add(model).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
            if (this.transact) {
                transaction.execute();
            } else {
                transaction.executeSync();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int location, @NonNull Collection<? extends TModel> collection) {
        return this.addAll(collection);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends TModel> collection) {
        Collection<? extends TModel> tmpCollection = collection;
        Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder<TModel>(this.saveModel).addAll(tmpCollection).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
        if (this.transact) {
            transaction.execute();
        } else {
            transaction.executeSync();
        }
        return true;
    }

    @Override
    public void clear() {
        Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new QueryTransaction.Builder<TModel>(SQLite.delete().from(this.internalCursorList.table())).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
        if (this.transact) {
            transaction.execute();
        } else {
            transaction.executeSync();
        }
    }

    @Override
    public boolean contains(@Nullable Object object) {
        boolean contains = false;
        if (object != null && this.internalCursorList.table().isAssignableFrom(object.getClass())) {
            Object model = object;
            contains = this.internalCursorList.getInstanceAdapter().exists(model);
        }
        return contains;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        boolean contains;
        boolean bl = contains = !collection.isEmpty();
        if (contains) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                contains = false;
                break;
            }
        }
        return contains;
    }

    @Override
    public long getCount() {
        return this.internalCursorList.getCount();
    }

    @Override
    @Nullable
    public TModel getItem(long position) {
        return this.internalCursorList.getItem(position);
    }

    @Override
    @Nullable
    public Cursor cursor() {
        return this.internalCursorList.cursor();
    }

    @Override
    @Nullable
    public TModel get(int row) {
        return this.internalCursorList.getItem(row);
    }

    @Override
    public int indexOf(Object object) {
        throw new UnsupportedOperationException("We cannot determine which index in the table this item exists at efficiently");
    }

    @Override
    public boolean isEmpty() {
        return this.internalCursorList.isEmpty();
    }

    @Override
    @NonNull
    public FlowCursorIterator<TModel> iterator() {
        return new FlowCursorIterator(this);
    }

    @Override
    @NonNull
    public FlowCursorIterator<TModel> iterator(int startingLocation, long limit) {
        return new FlowCursorIterator(this, startingLocation, limit);
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new UnsupportedOperationException("We cannot determine which index in the table this item exists at efficiently");
    }

    @Override
    @NonNull
    public ListIterator<TModel> listIterator() {
        return new FlowCursorIterator(this);
    }

    @Override
    @NonNull
    public ListIterator<TModel> listIterator(int location) {
        return new FlowCursorIterator(this, location);
    }

    @Override
    public TModel remove(int location) {
        TModel model = this.internalCursorList.getItem(location);
        Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder<TModel>(this.deleteModel).add(model).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
        if (this.transact) {
            transaction.execute();
        } else {
            transaction.executeSync();
        }
        return model;
    }

    @Override
    public boolean remove(Object object) {
        boolean removed = false;
        if (this.internalCursorList.table().isAssignableFrom(object.getClass())) {
            Object model = object;
            Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder<Object>(this.deleteModel).add(model).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
            if (this.transact) {
                transaction.execute();
            } else {
                transaction.executeSync();
            }
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        Collection<?> modelCollection = collection;
        Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder(this.deleteModel).addAll(modelCollection).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
        if (this.transact) {
            transaction.execute();
        } else {
            transaction.executeSync();
        }
        return true;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        List<TModel> tableList = this.internalCursorList.getAll();
        tableList.removeAll(collection);
        Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder<TModel>(tableList, this.deleteModel).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
        if (this.transact) {
            transaction.execute();
        } else {
            transaction.executeSync();
        }
        return true;
    }

    @Override
    public TModel set(int location, TModel object) {
        return this.set(object);
    }

    public TModel set(TModel object) {
        Transaction transaction = FlowManager.getDatabaseForTable(this.internalCursorList.table()).beginTransactionAsync(new ProcessModelTransaction.Builder<TModel>(this.updateModel).add(object).build()).error(this.internalErrorCallback).success(this.internalSuccessCallback).build();
        if (this.transact) {
            transaction.execute();
        } else {
            transaction.executeSync();
        }
        return object;
    }

    @Override
    public int size() {
        return (int)this.internalCursorList.getCount();
    }

    @Override
    @NonNull
    public List<TModel> subList(int start, int end) {
        List<TModel> tableList = this.internalCursorList.getAll();
        return tableList.subList(start, end);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        List<TModel> tableList = this.internalCursorList.getAll();
        return tableList.toArray();
    }

    @Override
    @NonNull
    public <T> T[] toArray(T[] array) {
        List<TModel> tableList = this.internalCursorList.getAll();
        return tableList.toArray(array);
    }

    @Override
    public void close() {
        this.internalCursorList.close();
    }

    public static class Builder<TModel> {
        private final Class<TModel> table;
        private boolean transact;
        private boolean changeInTransaction;
        private Cursor cursor;
        private boolean cacheModels = true;
        private ModelQueriable<TModel> modelQueriable;
        private ModelCache<TModel, ?> modelCache;
        private Transaction.Success success;
        private Transaction.Error error;

        private Builder(FlowCursorList<TModel> cursorList) {
            this.table = cursorList.table();
            this.cursor = cursorList.cursor();
            this.cacheModels = cursorList.cachingEnabled();
            this.modelQueriable = cursorList.modelQueriable();
            this.modelCache = cursorList.modelCache();
        }

        public Builder(Class<TModel> table) {
            this.table = table;
        }

        public Builder(@NonNull ModelQueriable<TModel> modelQueriable) {
            this(modelQueriable.getTable());
            this.modelQueriable(modelQueriable);
        }

        public Builder<TModel> cursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder<TModel> modelQueriable(ModelQueriable<TModel> modelQueriable) {
            this.modelQueriable = modelQueriable;
            return this;
        }

        public Builder<TModel> transact(boolean transact) {
            this.transact = transact;
            return this;
        }

        public Builder<TModel> modelCache(ModelCache<TModel, ?> modelCache) {
            this.modelCache = modelCache;
            return this;
        }

        public Builder<TModel> changeInTransaction(boolean changeInTransaction) {
            this.changeInTransaction = changeInTransaction;
            return this;
        }

        public Builder<TModel> cacheModels(boolean cacheModels) {
            this.cacheModels = cacheModels;
            return this;
        }

        public Builder<TModel> success(Transaction.Success success) {
            this.success = success;
            return this;
        }

        public Builder<TModel> error(Transaction.Error error) {
            this.error = error;
            return this;
        }

        public FlowQueryList<TModel> build() {
            return new FlowQueryList(this);
        }
    }
}

