/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;

public class SparseArrayBasedCache<TModel>
extends ModelCache<TModel, SparseArray<TModel>> {
    public SparseArrayBasedCache() {
        super(new SparseArray());
    }

    public SparseArrayBasedCache(int initialCapacity) {
        super(new SparseArray(initialCapacity));
    }

    public SparseArrayBasedCache(@NonNull SparseArray<TModel> sparseArray) {
        super(sparseArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModel(@Nullable Object id, @NonNull TModel model) {
        if (id instanceof Number) {
            SparseArray sparseArray = (SparseArray)this.getCache();
            synchronized (sparseArray) {
                ((SparseArray)this.getCache()).put(((Number)id).intValue(), model);
            }
        } else {
            throw new IllegalArgumentException("A SparseArrayBasedCache must use an id that can cast to a Number to convert it into a int");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TModel removeModel(@NonNull Object id) {
        TModel model = this.get(id);
        SparseArray sparseArray = (SparseArray)this.getCache();
        synchronized (sparseArray) {
            ((SparseArray)this.getCache()).remove(((Number)id).intValue());
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        SparseArray sparseArray = (SparseArray)this.getCache();
        synchronized (sparseArray) {
            ((SparseArray)this.getCache()).clear();
        }
    }

    @Override
    public void setCacheSize(int size) {
        FlowLog.log(FlowLog.Level.I, "The cache size for " + SparseArrayBasedCache.class.getSimpleName() + " is not re-configurable.");
    }

    @Override
    public TModel get(@Nullable Object id) {
        if (id instanceof Number) {
            return (TModel)((SparseArray)this.getCache()).get(((Number)id).intValue());
        }
        throw new IllegalArgumentException("A SparseArrayBasedCache uses an id that can cast to a Number to convert it into a int");
    }
}

