/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.queriable;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.queriable.ListModelLoader;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;
import java.util.ArrayList;
import java.util.List;

public class CacheableListModelLoader<TModel>
extends ListModelLoader<TModel> {
    private ModelAdapter<TModel> modelAdapter;
    private ModelCache<TModel, ?> modelCache;

    public CacheableListModelLoader(@NonNull Class<TModel> modelClass) {
        super(modelClass);
    }

    @NonNull
    public ModelCache<TModel, ?> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = this.modelAdapter.getModelCache();
            if (this.modelCache == null) {
                throw new IllegalArgumentException("ModelCache specified in convertToCacheableList() must not be null.");
            }
        }
        return this.modelCache;
    }

    @NonNull
    public ModelAdapter<TModel> getModelAdapter() {
        if (this.modelAdapter == null) {
            if (!(this.getInstanceAdapter() instanceof ModelAdapter)) {
                throw new IllegalArgumentException("A non-Table type was used.");
            }
            this.modelAdapter = (ModelAdapter)this.getInstanceAdapter();
            if (!this.modelAdapter.cachingEnabled()) {
                throw new IllegalArgumentException("You cannot call this method for a table that has no caching id. Eitheruse one Primary Key or use the MultiCacheKeyConverter");
            }
        }
        return this.modelAdapter;
    }

    @Override
    @NonNull
    public List<TModel> convertToData(@NonNull FlowCursor cursor, @Nullable List<TModel> data) {
        if (data == null) {
            data = new ArrayList<TModel>();
        }
        Object[] cacheValues = new Object[this.getModelAdapter().getCachingColumns().length];
        if (cursor.moveToFirst()) {
            do {
                Object[] values = this.getModelAdapter().getCachingColumnValuesFromCursor(cacheValues, cursor);
                TModel model = this.getModelCache().get(this.getModelAdapter().getCachingId(values));
                if (model != null) {
                    this.getModelAdapter().reloadRelationships(model, cursor);
                    data.add(model);
                    continue;
                }
                model = this.getModelAdapter().newInstance();
                this.getModelAdapter().loadFromCursor(cursor, model);
                this.getModelCache().addModel(this.getModelAdapter().getCachingId(values), model);
                data.add(model);
            } while (cursor.moveToNext());
        }
        return data;
    }
}

