/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PriorityTransactionWrapper
implements ITransaction,
Comparable<PriorityTransactionWrapper> {
    public static final int PRIORITY_LOW = 0;
    public static final int PRIORITY_NORMAL = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_UI = 5;
    private final int priority;
    private final ITransaction transaction;

    PriorityTransactionWrapper(Builder builder) {
        this.priority = builder.priority == 0 ? 1 : builder.priority;
        this.transaction = builder.transaction;
    }

    @Override
    public void execute(DatabaseWrapper databaseWrapper) {
        this.transaction.execute(databaseWrapper);
    }

    @Override
    public int compareTo(@NonNull PriorityTransactionWrapper another) {
        return another.priority - this.priority;
    }

    public static class Builder {
        private final ITransaction transaction;
        private int priority;

        public Builder(@NonNull ITransaction transaction) {
            this.transaction = transaction;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public PriorityTransactionWrapper build() {
            return new PriorityTransactionWrapper(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }
}

