/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;

public class ListModelSaver<TModel> {
    private final ModelSaver<TModel> modelSaver;

    public ListModelSaver(@NonNull ModelSaver<TModel> modelSaver) {
        this.modelSaver = modelSaver;
    }

    public synchronized void saveAll(@NonNull Collection<TModel> tableCollection) {
        this.saveAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveAll(@NonNull Collection<TModel> tableCollection, @NonNull DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        DatabaseStatement statement = this.modelSaver.getModelAdapter().getInsertStatement(wrapper);
        DatabaseStatement updateStatement = this.modelSaver.getModelAdapter().getUpdateStatement(wrapper);
        try {
            for (TModel model : tableCollection) {
                this.modelSaver.save(model, wrapper, statement, updateStatement);
            }
        }
        finally {
            statement.close();
        }
    }

    public synchronized void insertAll(@NonNull Collection<TModel> tableCollection) {
        this.insertAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertAll(@NonNull Collection<TModel> tableCollection, @NonNull DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        try (DatabaseStatement statement = this.modelSaver.getModelAdapter().getInsertStatement(wrapper);){
            for (TModel model : tableCollection) {
                this.modelSaver.insert(model, statement, wrapper);
            }
        }
    }

    public synchronized void updateAll(@NonNull Collection<TModel> tableCollection) {
        this.updateAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateAll(@NonNull Collection<TModel> tableCollection, @NonNull DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        try (DatabaseStatement updateStatement = this.modelSaver.getModelAdapter().getUpdateStatement(wrapper);){
            for (TModel model : tableCollection) {
                this.modelSaver.update(model, wrapper, updateStatement);
            }
        }
    }

    public synchronized void deleteAll(@NonNull Collection<TModel> tableCollection) {
        this.deleteAll(tableCollection, this.modelSaver.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAll(@NonNull Collection<TModel> tableCollection, @NonNull DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        try (DatabaseStatement deleteStatement = this.modelSaver.getModelAdapter().getDeleteStatement(wrapper);){
            for (TModel model : tableCollection) {
                this.modelSaver.delete(model, deleteStatement, wrapper);
            }
        }
    }

    @NonNull
    public ModelSaver<TModel> getModelSaver() {
        return this.modelSaver;
    }
}

