/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.list;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.list.IFlowCursorIterator;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;

public class FlowCursorIterator<TModel>
implements ListIterator<TModel>,
AutoCloseable {
    private final IFlowCursorIterator<TModel> cursorList;
    private long reverseIndex;
    private long startingCount;
    private long count;

    public FlowCursorIterator(@NonNull IFlowCursorIterator<TModel> cursorList) {
        this(cursorList, 0, cursorList.getCount());
    }

    public FlowCursorIterator(@NonNull IFlowCursorIterator<TModel> cursorList, int startingLocation) {
        this(cursorList, startingLocation, cursorList.getCount() - (long)startingLocation);
    }

    public FlowCursorIterator(@NonNull IFlowCursorIterator<TModel> cursorList, int startingLocation, long count) {
        this.cursorList = cursorList;
        this.count = count;
        Cursor cursor = cursorList.cursor();
        if (cursor != null) {
            if (this.count > (long)(cursor.getCount() - startingLocation)) {
                this.count = cursor.getCount() - startingLocation;
            }
            cursor.moveToPosition(startingLocation - 1);
            this.startingCount = cursorList.getCount();
            this.reverseIndex = this.count;
            this.reverseIndex -= (long)startingLocation;
            if (this.reverseIndex < 0L) {
                this.reverseIndex = 0L;
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.cursorList.close();
    }

    @Override
    public void add(@Nullable TModel object) {
        throw new UnsupportedOperationException("Cursor Iterator: Cannot add a model in the iterator");
    }

    @Override
    public boolean hasNext() {
        this.checkSizes();
        return this.reverseIndex > 0L;
    }

    @Override
    public boolean hasPrevious() {
        this.checkSizes();
        return this.reverseIndex < this.count;
    }

    @Override
    @Nullable
    public TModel next() {
        this.checkSizes();
        TModel item = this.cursorList.getItem(this.count - this.reverseIndex);
        --this.reverseIndex;
        return item;
    }

    @Override
    public int nextIndex() {
        return (int)(this.reverseIndex + 1L);
    }

    @Override
    @Nullable
    public TModel previous() {
        this.checkSizes();
        TModel item = this.cursorList.getItem(this.count - this.reverseIndex);
        ++this.reverseIndex;
        return item;
    }

    @Override
    public int previousIndex() {
        return (int)this.reverseIndex;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cursor Iterator: cannot remove from an active Iterator ");
    }

    @Override
    public void set(@Nullable TModel object) {
        throw new UnsupportedOperationException("Cursor Iterator: cannot set on an active Iterator ");
    }

    private void checkSizes() {
        if (this.startingCount != this.cursorList.getCount()) {
            throw new ConcurrentModificationException("Cannot change Cursor data during iteration.");
        }
    }
}

