/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class ModelSaver<TModel> {
    private static final int INSERT_FAILED = -1;
    private ModelAdapter<TModel> modelAdapter;

    public void setModelAdapter(@NonNull ModelAdapter<TModel> modelAdapter) {
        this.modelAdapter = modelAdapter;
    }

    public synchronized boolean save(@NonNull TModel model) {
        return this.save(model, this.getWritableDatabase(), this.modelAdapter.getInsertStatement(), this.modelAdapter.getUpdateStatement());
    }

    public synchronized boolean save(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
        return this.save(model, wrapper, this.modelAdapter.getInsertStatement(wrapper), this.modelAdapter.getUpdateStatement(wrapper));
    }

    public synchronized boolean save(@NonNull TModel model, DatabaseWrapper wrapper, @NonNull DatabaseStatement insertStatement, @NonNull DatabaseStatement updateStatement) {
        boolean exists = this.modelAdapter.exists(model, wrapper);
        if (exists) {
            exists = this.update(model, wrapper, updateStatement);
        }
        if (!exists) {
            boolean bl = exists = this.insert(model, insertStatement, wrapper) > -1L;
        }
        if (exists) {
            NotifyDistributor.get().notifyModelChanged(model, this.modelAdapter, BaseModel.Action.SAVE);
        }
        return exists;
    }

    public synchronized boolean update(@NonNull TModel model) {
        return this.update(model, this.getWritableDatabase(), this.modelAdapter.getUpdateStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean update(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
        boolean success = false;
        try (DatabaseStatement insertStatement = this.modelAdapter.getUpdateStatement(wrapper);){
            success = this.update(model, wrapper, insertStatement);
        }
        return success;
    }

    public synchronized boolean update(@NonNull TModel model, @NonNull DatabaseWrapper wrapper, @NonNull DatabaseStatement databaseStatement) {
        boolean successful;
        this.modelAdapter.saveForeignKeys(model, wrapper);
        this.modelAdapter.bindToUpdateStatement(databaseStatement, model);
        boolean bl = successful = databaseStatement.executeUpdateDelete() != 0L;
        if (successful) {
            NotifyDistributor.get().notifyModelChanged(model, this.modelAdapter, BaseModel.Action.UPDATE);
        }
        return successful;
    }

    public synchronized long insert(@NonNull TModel model) {
        return this.insert(model, this.modelAdapter.getInsertStatement(), this.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long insert(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
        long result = 0L;
        try (DatabaseStatement insertStatement = this.modelAdapter.getInsertStatement(wrapper);){
            result = this.insert(model, insertStatement, wrapper);
        }
        return result;
    }

    public synchronized long insert(@NonNull TModel model, @NonNull DatabaseStatement insertStatement, @NonNull DatabaseWrapper wrapper) {
        this.modelAdapter.saveForeignKeys(model, wrapper);
        this.modelAdapter.bindToInsertStatement(insertStatement, model);
        long id = insertStatement.executeInsert();
        if (id > -1L) {
            this.modelAdapter.updateAutoIncrement(model, id);
            NotifyDistributor.get().notifyModelChanged(model, this.modelAdapter, BaseModel.Action.INSERT);
        }
        return id;
    }

    public synchronized boolean delete(@NonNull TModel model) {
        return this.delete(model, this.modelAdapter.getDeleteStatement(), this.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean delete(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
        boolean success = false;
        try (DatabaseStatement deleteStatement = this.modelAdapter.getDeleteStatement(wrapper);){
            success = this.delete(model, deleteStatement, wrapper);
        }
        return success;
    }

    public synchronized boolean delete(@NonNull TModel model, @NonNull DatabaseStatement deleteStatement, @NonNull DatabaseWrapper wrapper) {
        boolean success;
        this.modelAdapter.deleteForeignKeys(model, wrapper);
        this.modelAdapter.bindToDeleteStatement(deleteStatement, model);
        boolean bl = success = deleteStatement.executeUpdateDelete() != 0L;
        if (success) {
            NotifyDistributor.get().notifyModelChanged(model, this.modelAdapter, BaseModel.Action.DELETE);
        }
        this.modelAdapter.updateAutoIncrement(model, 0);
        return success;
    }

    protected DatabaseWrapper getWritableDatabase() {
        return FlowManager.getDatabaseForTable(this.modelAdapter.getModelClass()).getWritableDatabase();
    }

    @NonNull
    public ModelAdapter<TModel> getModelAdapter() {
        return this.modelAdapter;
    }

    @Deprecated
    public synchronized boolean save(@NonNull TModel model, @NonNull DatabaseWrapper wrapper, @NonNull DatabaseStatement insertStatement, @NonNull ContentValues contentValues) {
        boolean exists = this.modelAdapter.exists(model, wrapper);
        if (exists) {
            exists = this.update(model, wrapper, contentValues);
        }
        if (!exists) {
            boolean bl = exists = this.insert(model, insertStatement, wrapper) > -1L;
        }
        if (exists) {
            NotifyDistributor.get().notifyModelChanged(model, this.modelAdapter, BaseModel.Action.SAVE);
        }
        return exists;
    }

    @Deprecated
    public synchronized boolean update(@NonNull TModel model, @NonNull DatabaseWrapper wrapper, @NonNull ContentValues contentValues) {
        boolean successful;
        this.modelAdapter.saveForeignKeys(model, wrapper);
        this.modelAdapter.bindToContentValues(contentValues, model);
        boolean bl = successful = wrapper.updateWithOnConflict(this.modelAdapter.getTableName(), contentValues, this.modelAdapter.getPrimaryConditionClause(model).getQuery(), null, ConflictAction.getSQLiteDatabaseAlgorithmInt((ConflictAction)this.modelAdapter.getUpdateOnConflictAction())) != 0L;
        if (successful) {
            NotifyDistributor.get().notifyModelChanged(model, this.modelAdapter, BaseModel.Action.UPDATE);
        }
        return successful;
    }
}

