/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.queriable;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.queriable.SingleModelLoader;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;

public class CacheableModelLoader<TModel>
extends SingleModelLoader<TModel> {
    private ModelAdapter<TModel> modelAdapter;
    private ModelCache<TModel, ?> modelCache;

    public CacheableModelLoader(Class<TModel> modelClass) {
        super(modelClass);
    }

    public ModelAdapter<TModel> getModelAdapter() {
        if (this.modelAdapter == null) {
            if (!(this.getInstanceAdapter() instanceof ModelAdapter)) {
                throw new IllegalArgumentException("A non-Table type was used.");
            }
            this.modelAdapter = (ModelAdapter)this.getInstanceAdapter();
            if (!this.modelAdapter.cachingEnabled()) {
                throw new IllegalArgumentException("You cannot call this method for a table that has no caching id. Eitheruse one Primary Key or use the MultiCacheKeyConverter");
            }
        }
        return this.modelAdapter;
    }

    public ModelCache<TModel, ?> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = this.getModelAdapter().getModelCache();
        }
        return this.modelCache;
    }

    @Override
    @Nullable
    public TModel convertToData(@NonNull FlowCursor cursor, @Nullable TModel data, boolean moveToFirst) {
        if (!moveToFirst || cursor.moveToFirst()) {
            Object[] values = this.getModelAdapter().getCachingColumnValuesFromCursor(new Object[this.getModelAdapter().getCachingColumns().length], cursor);
            TModel model = this.getModelCache().get(this.getModelAdapter().getCachingId(values));
            if (model == null) {
                model = data == null ? this.getModelAdapter().newInstance() : data;
                this.getModelAdapter().loadFromCursor(cursor, model);
                this.getModelCache().addModel(this.getModelAdapter().getCachingId(values), model);
            } else {
                this.getModelAdapter().reloadRelationships(model, cursor);
            }
            return model;
        }
        return null;
    }
}

