/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.queriable;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.queriable.CacheableListModelLoader;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;
import java.util.ArrayList;
import java.util.List;

public class SingleKeyCacheableListModelLoader<TModel>
extends CacheableListModelLoader<TModel> {
    public SingleKeyCacheableListModelLoader(Class<TModel> tModelClass) {
        super(tModelClass);
    }

    @Override
    @NonNull
    public List<TModel> convertToData(@NonNull FlowCursor cursor, @Nullable List<TModel> data) {
        if (data == null) {
            data = new ArrayList<TModel>();
        }
        if (cursor.moveToFirst()) {
            do {
                Object cacheValue = this.getModelAdapter().getCachingColumnValueFromCursor(cursor);
                Object model = this.getModelCache().get(cacheValue);
                if (model != null) {
                    this.getModelAdapter().reloadRelationships(model, cursor);
                    data.add(model);
                    continue;
                }
                model = this.getModelAdapter().newInstance();
                this.getModelAdapter().loadFromCursor(cursor, model);
                this.getModelCache().addModel(cacheValue, model);
                data.add(model);
            } while (cursor.moveToNext());
        }
        return data;
    }
}

