/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseOperator;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OperatorGroup
extends BaseOperator
implements Query,
Iterable<SQLOperator> {
    @NonNull
    private final List<SQLOperator> conditionsList = new ArrayList<SQLOperator>();
    private QueryBuilder query;
    private boolean isChanged;
    private boolean allCommaSeparated;
    private boolean useParenthesis = true;

    @NonNull
    public static OperatorGroup clause() {
        return new OperatorGroup();
    }

    @NonNull
    public static OperatorGroup clause(SQLOperator ... condition) {
        return new OperatorGroup().andAll(condition);
    }

    public static OperatorGroup nonGroupingClause() {
        return new OperatorGroup().setUseParenthesis(false);
    }

    public static OperatorGroup nonGroupingClause(SQLOperator ... condition) {
        return new OperatorGroup().setUseParenthesis(false).andAll(condition);
    }

    protected OperatorGroup(NameAlias columnName) {
        super(columnName);
        this.separator = "AND";
    }

    protected OperatorGroup() {
        this(null);
    }

    @NonNull
    public OperatorGroup setAllCommaSeparated(boolean allCommaSeparated) {
        this.allCommaSeparated = allCommaSeparated;
        this.isChanged = true;
        return this;
    }

    @NonNull
    public OperatorGroup setUseParenthesis(boolean useParenthesis) {
        this.useParenthesis = useParenthesis;
        this.isChanged = true;
        return this;
    }

    @NonNull
    public OperatorGroup or(SQLOperator sqlOperator) {
        return this.operator("OR", sqlOperator);
    }

    @NonNull
    public OperatorGroup and(SQLOperator sqlOperator) {
        return this.operator("AND", sqlOperator);
    }

    @NonNull
    public OperatorGroup andAll(SQLOperator ... sqlOperators) {
        for (SQLOperator sqlOperator : sqlOperators) {
            this.and(sqlOperator);
        }
        return this;
    }

    @NonNull
    public OperatorGroup andAll(Collection<SQLOperator> sqlOperators) {
        for (SQLOperator sqlOperator : sqlOperators) {
            this.and(sqlOperator);
        }
        return this;
    }

    @NonNull
    public OperatorGroup orAll(SQLOperator ... sqlOperators) {
        for (SQLOperator sqlOperator : sqlOperators) {
            this.or(sqlOperator);
        }
        return this;
    }

    @NonNull
    public OperatorGroup orAll(Collection<SQLOperator> sqlOperators) {
        for (SQLOperator sqlOperator : sqlOperators) {
            this.or(sqlOperator);
        }
        return this;
    }

    @NonNull
    private OperatorGroup operator(String operator, @Nullable SQLOperator sqlOperator) {
        if (sqlOperator != null) {
            this.setPreviousSeparator(operator);
            this.conditionsList.add(sqlOperator);
            this.isChanged = true;
        }
        return this;
    }

    @Override
    public void appendConditionToQuery(QueryBuilder queryBuilder) {
        int conditionListSize = this.conditionsList.size();
        if (this.useParenthesis && conditionListSize > 0) {
            queryBuilder.append((Object)"(");
        }
        for (int i = 0; i < conditionListSize; ++i) {
            SQLOperator condition = this.conditionsList.get(i);
            condition.appendConditionToQuery(queryBuilder);
            if (!this.allCommaSeparated && condition.hasSeparator() && i < conditionListSize - 1) {
                queryBuilder.appendSpaceSeparated((Object)condition.separator());
                continue;
            }
            if (i >= conditionListSize - 1) continue;
            queryBuilder.append((Object)", ");
        }
        if (this.useParenthesis && conditionListSize > 0) {
            queryBuilder.append((Object)")");
        }
    }

    private void setPreviousSeparator(String separator) {
        if (this.conditionsList.size() > 0) {
            this.conditionsList.get(this.conditionsList.size() - 1).separator(separator);
        }
    }

    public String getQuery() {
        if (this.isChanged) {
            this.query = this.getQuerySafe();
        }
        return this.query == null ? "" : this.query.toString();
    }

    public String toString() {
        return this.getQuerySafe().toString();
    }

    public int size() {
        return this.conditionsList.size();
    }

    @NonNull
    public List<SQLOperator> getConditions() {
        return this.conditionsList;
    }

    @Override
    public Iterator<SQLOperator> iterator() {
        return this.conditionsList.iterator();
    }

    private QueryBuilder getQuerySafe() {
        QueryBuilder query = new QueryBuilder();
        this.appendConditionToQuery(query);
        return query;
    }
}

