/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;

public class DatabaseStatementWrapper<TModel>
implements DatabaseStatement {
    @NonNull
    private final DatabaseStatement databaseStatement;
    private final BaseQueriable<TModel> modelQueriable;

    public DatabaseStatementWrapper(@NonNull DatabaseStatement databaseStatement, BaseQueriable<TModel> modelQueriable) {
        this.databaseStatement = databaseStatement;
        this.modelQueriable = modelQueriable;
    }

    @Override
    public long executeUpdateDelete() {
        long affected = this.databaseStatement.executeUpdateDelete();
        if (affected > 0L) {
            NotifyDistributor.get().notifyTableChanged(this.modelQueriable.getTable(), this.modelQueriable.getPrimaryAction());
        }
        return affected;
    }

    @Override
    public void execute() {
        this.databaseStatement.execute();
    }

    @Override
    public void close() {
        this.databaseStatement.close();
    }

    @Override
    public long simpleQueryForLong() {
        return this.databaseStatement.simpleQueryForLong();
    }

    @Override
    public String simpleQueryForString() {
        return this.databaseStatement.simpleQueryForString();
    }

    @Override
    public long executeInsert() {
        long affected = this.databaseStatement.executeInsert();
        if (affected > 0L) {
            NotifyDistributor.get().notifyTableChanged(this.modelQueriable.getTable(), this.modelQueriable.getPrimaryAction());
        }
        return affected;
    }

    @Override
    public void bindString(int index, String name) {
        this.databaseStatement.bindString(index, name);
    }

    @Override
    public void bindNull(int index) {
        this.databaseStatement.bindNull(index);
    }

    @Override
    public void bindLong(int index, long aLong) {
        this.databaseStatement.bindLong(index, aLong);
    }

    @Override
    public void bindDouble(int index, double aDouble) {
        this.databaseStatement.bindDouble(index, aDouble);
    }

    @Override
    public void bindBlob(int index, byte[] bytes) {
        this.databaseStatement.bindBlob(index, bytes);
    }
}

