/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DirectModelNotifier
implements ModelNotifier {
    private static DirectModelNotifier notifier;
    private final Map<Class<?>, Set<ModelChangedListener>> modelChangedListenerMap = new LinkedHashMap();

    public static DirectModelNotifier get() {
        if (notifier == null) {
            notifier = new DirectModelNotifier();
        }
        return notifier;
    }

    private DirectModelNotifier() {
        if (notifier != null) {
            throw new IllegalStateException("Cannot instantiate more than one DirectNotifier. Use DirectNotifier.get()");
        }
    }

    @Override
    public <T> void notifyModelChanged(@Nullable T model, @NonNull ModelAdapter<T> adapter, @NonNull BaseModel.Action action) {
        Set<ModelChangedListener> listeners = this.modelChangedListenerMap.get(adapter.getModelClass());
        if (listeners != null) {
            for (ModelChangedListener listener : listeners) {
                if (listener == null) continue;
                listener.onModelChanged(model, action);
            }
        }
    }

    @Override
    public <T> void notifyTableChanged(@NonNull Class<T> table, @NonNull BaseModel.Action action) {
        Set<ModelChangedListener> listeners = this.modelChangedListenerMap.get(table);
        if (listeners != null) {
            for (ModelChangedListener listener : listeners) {
                if (listener == null) continue;
                listener.onTableChanged(action);
            }
        }
    }

    public <T> void registerForModelChanges(Class<T> table, ModelChangedListener<T> listener) {
        Set<ModelChangedListener> listeners = this.modelChangedListenerMap.get(table);
        if (listeners == null) {
            listeners = new LinkedHashSet<ModelChangedListener>();
            this.modelChangedListenerMap.put(table, listeners);
        }
        listeners.add(listener);
    }

    public <T> void unregisterForModelChanges(Class<T> table, ModelChangedListener<T> listener) {
        Set<ModelChangedListener> listeners = this.modelChangedListenerMap.get(table);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public static interface ModelChangedListener<T> {
        public void onModelChanged(T var1, BaseModel.Action var2);

        public void onTableChanged(BaseModel.Action var1);
    }
}

