/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.saveable.ListModelSaver;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;

public class CacheableListModelSaver<TModel>
extends ListModelSaver<TModel> {
    public CacheableListModelSaver(ModelSaver<TModel> modelSaver) {
        super(modelSaver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        ModelAdapter<TModel> modelAdapter = modelSaver.getModelAdapter();
        ContentValues contentValues = new ContentValues();
        try (DatabaseStatement statement = modelAdapter.getInsertStatement(wrapper);){
            for (TModel model : tableCollection) {
                if (!modelSaver.save(model, wrapper, statement, contentValues)) continue;
                modelAdapter.storeModelInCache(model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        ModelAdapter<TModel> modelAdapter = modelSaver.getModelAdapter();
        try (DatabaseStatement statement = modelAdapter.getInsertStatement(wrapper);){
            for (TModel model : tableCollection) {
                if (modelSaver.insert(model, statement, wrapper) <= 0L) continue;
                modelAdapter.storeModelInCache(model);
            }
        }
    }

    @Override
    public synchronized void updateAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        ModelAdapter<TModel> modelAdapter = modelSaver.getModelAdapter();
        ContentValues contentValues = new ContentValues();
        for (TModel model : tableCollection) {
            if (!modelSaver.update(model, wrapper, contentValues)) continue;
            modelAdapter.storeModelInCache(model);
        }
    }
}

