/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.list;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.list.FlowCursorIterator;
import com.raizlabs.android.dbflow.list.IFlowCursorIterator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.cache.ModelLruCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FlowCursorList<TModel>
implements Iterable<TModel>,
IFlowCursorIterator<TModel> {
    public static final int DEFAULT_CACHE_SIZE = 50;
    public static final int MIN_CACHE_SIZE = 20;
    @Nullable
    private Cursor cursor;
    private Class<TModel> table;
    private ModelCache<TModel, ?> modelCache;
    private boolean cacheModels;
    @Nullable
    private ModelQueriable<TModel> modelQueriable;
    private InstanceAdapter<TModel> instanceAdapter;
    private final Set<OnCursorRefreshListener<TModel>> cursorRefreshListenerSet = new HashSet<OnCursorRefreshListener<TModel>>();

    private FlowCursorList(Builder<TModel> builder) {
        this.table = ((Builder)builder).modelClass;
        this.modelQueriable = ((Builder)builder).modelQueriable;
        if (((Builder)builder).modelQueriable == null) {
            this.cursor = ((Builder)builder).cursor;
            if (this.cursor == null) {
                this.modelQueriable = SQLite.select(new IProperty[0]).from(this.table);
                this.cursor = this.modelQueriable.query();
            }
        } else {
            this.cursor = ((Builder)builder).modelQueriable.query();
        }
        this.cacheModels = ((Builder)builder).cacheModels;
        if (this.cacheModels) {
            this.modelCache = ((Builder)builder).modelCache;
            if (this.modelCache == null) {
                this.modelCache = ModelLruCache.newInstance(0);
            }
        }
        this.instanceAdapter = FlowManager.getInstanceAdapter(((Builder)builder).modelClass);
        this.setCacheModels(this.cacheModels);
    }

    InstanceAdapter<TModel> getInstanceAdapter() {
        return this.instanceAdapter;
    }

    ModelAdapter<TModel> getModelAdapter() {
        return (ModelAdapter)this.instanceAdapter;
    }

    @Override
    public FlowCursorIterator<TModel> iterator() {
        return new FlowCursorIterator(this);
    }

    @Override
    public FlowCursorIterator<TModel> iterator(int startingLocation, long limit) {
        return new FlowCursorIterator(this, startingLocation, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCursorRefreshListener(OnCursorRefreshListener<TModel> onCursorRefreshListener) {
        Set<OnCursorRefreshListener<TModel>> set = this.cursorRefreshListenerSet;
        synchronized (set) {
            this.cursorRefreshListenerSet.add(onCursorRefreshListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCursorRefreshListener(OnCursorRefreshListener<TModel> onCursorRefreshListener) {
        Set<OnCursorRefreshListener<TModel>> set = this.cursorRefreshListenerSet;
        synchronized (set) {
            this.cursorRefreshListenerSet.remove(onCursorRefreshListener);
        }
    }

    void setCacheModels(boolean cacheModels) {
        this.cacheModels = cacheModels;
        if (!cacheModels) {
            this.clearCache();
        }
    }

    public void clearCache() {
        if (this.cacheModels) {
            this.modelCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        this.warnEmptyCursor();
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.modelQueriable == null) {
            throw new IllegalStateException("Cannot refresh this FlowCursorList. This list was instantiated from a Cursor. Once closed, we cannot reopen it. Construct a new instance and swap with this instance.");
        }
        this.cursor = this.modelQueriable.query();
        if (this.cacheModels) {
            this.modelCache.clear();
            this.setCacheModels(true);
        }
        Set<OnCursorRefreshListener<TModel>> set = this.cursorRefreshListenerSet;
        synchronized (set) {
            for (OnCursorRefreshListener<TModel> listener : this.cursorRefreshListenerSet) {
                listener.onCursorRefreshed(this);
            }
        }
    }

    @Nullable
    public ModelQueriable<TModel> modelQueriable() {
        return this.modelQueriable;
    }

    @Override
    @Nullable
    public TModel getItem(long position) {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        Object model = null;
        if (this.cacheModels) {
            model = this.modelCache.get(position);
            if (model == null && this.cursor != null && this.cursor.moveToPosition((int)position)) {
                model = this.instanceAdapter.getSingleModelLoader().convertToData(this.cursor, null, false);
                this.modelCache.addModel(position, model);
            }
        } else if (this.cursor != null && this.cursor.moveToPosition((int)position)) {
            model = this.instanceAdapter.getSingleModelLoader().convertToData(this.cursor, null, false);
        }
        return model;
    }

    public List<TModel> getAll() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        if (!this.cacheModels) {
            return this.cursor == null ? new ArrayList() : FlowManager.getModelAdapter(this.table).getListModelLoader().convertToData(this.cursor, null);
        }
        ArrayList list = new ArrayList();
        for (Object model : this) {
            list.add(model);
        }
        return list;
    }

    public boolean isEmpty() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.getCount() == 0L;
    }

    @Override
    public long getCount() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.cursor != null ? (long)this.cursor.getCount() : 0L;
    }

    public ModelCache<TModel, ?> modelCache() {
        return this.modelCache;
    }

    public boolean cachingEnabled() {
        return this.cacheModels;
    }

    @Override
    public void close() {
        this.warnEmptyCursor();
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = null;
    }

    @Override
    @Nullable
    public Cursor cursor() {
        this.throwIfCursorClosed();
        this.warnEmptyCursor();
        return this.cursor;
    }

    public Class<TModel> table() {
        return this.table;
    }

    private void throwIfCursorClosed() {
        if (this.cursor != null && this.cursor.isClosed()) {
            throw new IllegalStateException("Cursor has been closed for FlowCursorList");
        }
    }

    private void warnEmptyCursor() {
        if (this.cursor == null) {
            FlowLog.log(FlowLog.Level.W, "Cursor was null for FlowCursorList");
        }
    }

    public Builder<TModel> newBuilder() {
        return new Builder<TModel>(this.table).modelQueriable(this.modelQueriable).cursor(this.cursor).cacheModels(this.cacheModels).modelCache(this.modelCache);
    }

    public static class Builder<TModel> {
        private final Class<TModel> modelClass;
        private Cursor cursor;
        private ModelQueriable<TModel> modelQueriable;
        private boolean cacheModels = true;
        private ModelCache<TModel, ?> modelCache;

        public Builder(Class<TModel> modelClass) {
            this.modelClass = modelClass;
        }

        public Builder(@NonNull ModelQueriable<TModel> modelQueriable) {
            this.modelClass = modelQueriable.getTable();
            this.modelQueriable(modelQueriable);
        }

        public Builder<TModel> cursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder<TModel> modelQueriable(ModelQueriable<TModel> modelQueriable) {
            this.modelQueriable = modelQueriable;
            return this;
        }

        public Builder<TModel> cacheModels(boolean cacheModels) {
            this.cacheModels = cacheModels;
            return this;
        }

        public Builder<TModel> modelCache(ModelCache<TModel, ?> modelCache) {
            this.modelCache = modelCache;
            if (modelCache != null) {
                this.cacheModels(true);
            }
            return this;
        }

        public FlowCursorList<TModel> build() {
            return new FlowCursorList(this);
        }
    }

    public static interface OnCursorRefreshListener<TModel> {
        public void onCursorRefreshed(FlowCursorList<TModel> var1);
    }
}

