/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.provider;

import android.database.Cursor;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import com.raizlabs.android.dbflow.structure.provider.ModelProvider;

public abstract class BaseSyncableProviderModel
extends BaseModel
implements ModelProvider {
    @Override
    public long insert() {
        long rowId = super.insert();
        ContentUtils.insert(this.getInsertUri(), this);
        return rowId;
    }

    @Override
    public boolean save() {
        if (this.exists()) {
            return super.save() && ContentUtils.update(this.getUpdateUri(), this) > 0;
        }
        return super.save() && ContentUtils.insert(this.getInsertUri(), this) != null;
    }

    @Override
    public boolean delete() {
        return super.delete() && ContentUtils.delete(this.getDeleteUri(), this) > 0;
    }

    @Override
    public boolean update() {
        return super.update() && ContentUtils.update(this.getUpdateUri(), this) > 0;
    }

    @Override
    public void load(ConditionGroup whereConditionGroup, String orderBy, String ... columns) {
        Cursor cursor = ContentUtils.query(FlowManager.getContext().getContentResolver(), this.getQueryUri(), whereConditionGroup, orderBy, columns);
        if (cursor != null && cursor.moveToFirst()) {
            this.getModelAdapter().loadFromCursor(cursor, this);
            cursor.close();
        }
    }

    @Override
    public void load() {
        this.load(this.getModelAdapter().getPrimaryConditionClause(this), "", new String[0]);
    }
}

