/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.cache;

import com.raizlabs.android.dbflow.structure.cache.LruCache;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;

public class ModelLruCache<TModel>
extends ModelCache<TModel, LruCache<Long, TModel>> {
    public static <TModel> ModelLruCache<TModel> newInstance(int size) {
        if (size <= 0) {
            size = 25;
        }
        return new ModelLruCache<TModel>(size);
    }

    protected ModelLruCache(int size) {
        super(new LruCache(size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModel(Object id, TModel model) {
        if (id instanceof Number) {
            LruCache lruCache = (LruCache)this.getCache();
            synchronized (lruCache) {
                Number number = (Number)id;
                ((LruCache)this.getCache()).put(number.longValue(), model);
            }
        } else {
            throw new IllegalArgumentException("A ModelLruCache must use an id that can cast toa Number to convert it into a long");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TModel removeModel(Object id) {
        Object model;
        if (id instanceof Number) {
            LruCache lruCache = (LruCache)this.getCache();
            synchronized (lruCache) {
                model = ((LruCache)this.getCache()).remove(((Number)id).longValue());
            }
        } else {
            throw new IllegalArgumentException("A ModelLruCache uses an id that can cast toa Number to convert it into a long");
        }
        return (TModel)model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LruCache lruCache = (LruCache)this.getCache();
        synchronized (lruCache) {
            ((LruCache)this.getCache()).evictAll();
        }
    }

    @Override
    public void setCacheSize(int size) {
        ((LruCache)this.getCache()).resize(size);
    }

    @Override
    public TModel get(Object id) {
        if (id instanceof Number) {
            return (TModel)((LruCache)this.getCache()).get(((Number)id).longValue());
        }
        throw new IllegalArgumentException("A ModelLruCache must use an id that can cast toa Number to convert it into a long");
    }
}

