/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.database.sqlite.SQLiteDoneException;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.queriable.Queriable;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public abstract class BaseQueriable<TModel>
implements Queriable {
    private final Class<TModel> table;

    protected BaseQueriable(Class<TModel> table) {
        this.table = table;
    }

    public Class<TModel> getTable() {
        return this.table;
    }

    @Override
    public long count(DatabaseWrapper databaseWrapper) {
        try {
            String query = this.getQuery();
            FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
            return SqlUtils.longForQuery(databaseWrapper, query);
        }
        catch (SQLiteDoneException sde) {
            FlowLog.log(FlowLog.Level.E, sde);
            return 0L;
        }
    }

    @Override
    public long count() {
        return this.count(FlowManager.getDatabaseForTable(this.getTable()).getWritableDatabase());
    }

    @Override
    public boolean hasData() {
        return this.count() > 0L;
    }

    @Override
    public boolean hasData(DatabaseWrapper databaseWrapper) {
        return this.count(databaseWrapper) > 0L;
    }

    @Override
    public Cursor query() {
        this.query(FlowManager.getDatabaseForTable(this.table).getWritableDatabase());
        return null;
    }

    @Override
    public Cursor query(DatabaseWrapper databaseWrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        databaseWrapper.execSQL(query);
        return null;
    }

    @Override
    public void execute() {
        Cursor cursor = this.query();
        if (cursor != null) {
            cursor.close();
        }
    }

    @Override
    public void execute(DatabaseWrapper databaseWrapper) {
        Cursor cursor = this.query(databaseWrapper);
        if (cursor != null) {
            cursor.close();
        }
    }

    @Override
    public DatabaseStatement compileStatement() {
        return this.compileStatement(FlowManager.getDatabaseForTable(this.table).getWritableDatabase());
    }

    @Override
    public DatabaseStatement compileStatement(DatabaseWrapper databaseWrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Compiling Query Into Statement: " + query);
        return databaseWrapper.compileStatement(query);
    }

    public String toString() {
        return this.getQuery();
    }
}

