/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.content.ContentValues;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.builder.ValueQueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.From;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Insert<TModel>
extends BaseQueriable<TModel> {
    private IProperty[] columns;
    private List<Object[]> valuesList;
    private ConflictAction conflictAction = ConflictAction.NONE;
    private From<?> selectFrom;

    public Insert(Class<TModel> table) {
        super(table);
    }

    public Insert<TModel> columns(String ... columns) {
        this.columns = new IProperty[columns.length];
        ModelAdapter modelClassModelAdapter = FlowManager.getModelAdapter(this.getTable());
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            this.columns[i] = modelClassModelAdapter.getProperty(column);
        }
        return this;
    }

    public Insert<TModel> columns(IProperty ... properties) {
        this.columns = new IProperty[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.columns[i] = properties[i];
        }
        return this;
    }

    public Insert<TModel> columns(List<IProperty> properties) {
        if (properties != null) {
            this.columns = new IProperty[properties.size()];
            for (int i = 0; i < properties.size(); ++i) {
                this.columns[i] = properties.get(i);
            }
        }
        return this;
    }

    public Insert<TModel> asColumns() {
        this.columns(FlowManager.getModelAdapter(this.getTable()).getAllColumnProperties());
        return this;
    }

    public Insert<TModel> values(Object ... values) {
        if (this.valuesList == null) {
            this.valuesList = new ArrayList<Object[]>();
        }
        this.valuesList.add(values);
        return this;
    }

    public Insert<TModel> columnValues(SQLCondition ... conditions) {
        String[] columns = new String[conditions.length];
        Object[] values = new Object[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            SQLCondition condition = conditions[i];
            columns[i] = condition.columnName();
            values[i] = condition.value();
        }
        return this.columns(columns).values(values);
    }

    public Insert<TModel> columnValues(ConditionGroup conditionGroup) {
        int size = conditionGroup.size();
        String[] columns = new String[size];
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            SQLCondition condition = conditionGroup.getConditions().get(i);
            columns[i] = condition.columnName();
            values[i] = condition.value();
        }
        return this.columns(columns).values(values);
    }

    public Insert<TModel> columnValues(ContentValues contentValues) {
        Set entries = contentValues.valueSet();
        int count = 0;
        String[] columns = new String[contentValues.size()];
        Object[] values = new Object[contentValues.size()];
        for (Map.Entry entry : entries) {
            String key;
            columns[count] = key = (String)entry.getKey();
            values[count] = contentValues.get(key);
            ++count;
        }
        return this.columns(columns).values(values);
    }

    public Insert<TModel> select(From<?> selectFrom) {
        this.selectFrom = selectFrom;
        return this;
    }

    public Insert<TModel> or(ConflictAction action) {
        this.conflictAction = action;
        return this;
    }

    public Insert<TModel> orReplace() {
        return this.or(ConflictAction.REPLACE);
    }

    public Insert<TModel> orRollback() {
        return this.or(ConflictAction.ROLLBACK);
    }

    public Insert<TModel> orAbort() {
        return this.or(ConflictAction.ABORT);
    }

    public Insert<TModel> orFail() {
        return this.or(ConflictAction.FAIL);
    }

    public Insert<TModel> orIgnore() {
        return this.or(ConflictAction.IGNORE);
    }

    @Override
    public long executeUpdateDelete(DatabaseWrapper databaseWrapper) {
        throw new IllegalStateException("Cannot call executeUpdateDelete() from an Insert");
    }

    @Override
    public long executeUpdateDelete() {
        throw new IllegalStateException("Cannot call executeUpdateDelete() from an Insert");
    }

    public String getQuery() {
        ValueQueryBuilder queryBuilder = new ValueQueryBuilder("INSERT ");
        if (this.conflictAction != null && !this.conflictAction.equals((Object)ConflictAction.NONE)) {
            ((ValueQueryBuilder)queryBuilder.append("OR")).appendSpaceSeparated(this.conflictAction);
        }
        ((ValueQueryBuilder)((ValueQueryBuilder)queryBuilder.append("INTO")).appendSpace()).appendTableName(this.getTable());
        if (this.columns != null) {
            ((ValueQueryBuilder)((ValueQueryBuilder)queryBuilder.append("(")).appendArray(this.columns)).append(")");
        }
        if (this.selectFrom != null) {
            ((ValueQueryBuilder)queryBuilder.appendSpace()).append(this.selectFrom.getQuery());
        } else {
            if (this.valuesList == null || this.valuesList.size() < 1) {
                throw new IllegalStateException("The insert of " + FlowManager.getTableName(this.getTable()) + " should haveat least one value specified for the insert");
            }
            if (this.columns != null) {
                for (Object[] values : this.valuesList) {
                    if (values.length == this.columns.length) continue;
                    throw new IllegalStateException("The Insert of " + FlowManager.getTableName(this.getTable()) + " when specifyingcolumns needs to have the same amount of values and columns");
                }
            }
            queryBuilder.append(" VALUES(");
            for (int i = 0; i < this.valuesList.size(); ++i) {
                if (i > 0) {
                    queryBuilder.append(",(");
                }
                queryBuilder.appendModelArray(this.valuesList.get(i)).append(")");
            }
        }
        return queryBuilder.getQuery();
    }
}

