/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.rx2.language;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.list.FlowCursorIterator;
import com.raizlabs.android.dbflow.rx2.language.RXModelQueriable;
import com.raizlabs.android.dbflow.sql.language.CursorResult;
import io.reactivex.Flowable;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class CursorResultFlowable<T>
extends Flowable<T> {
    @NonNull
    private final RXModelQueriable<T> modelQueriable;

    public CursorResultFlowable(@NonNull RXModelQueriable<T> modelQueriable) {
        this.modelQueriable = modelQueriable;
    }

    protected void subscribeActual(final Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                CursorResultFlowable.this.modelQueriable.queryResults().subscribe(new CursorResultObserver(subscriber, n));
            }

            public void cancel() {
            }
        });
    }

    @VisibleForTesting
    static class CursorResultObserver<T>
    implements SingleObserver<CursorResult<T>> {
        private final Subscriber<? super T> subscriber;
        private final long count;
        private final AtomicLong emitted;
        private final AtomicLong requested;
        private Disposable disposable;

        CursorResultObserver(Subscriber<? super T> subscriber, long count) {
            this.subscriber = subscriber;
            this.count = count;
            this.requested = new AtomicLong();
            this.emitted = new AtomicLong();
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(CursorResult<T> ts) {
            int starting = this.count == Long.MAX_VALUE && this.requested.compareAndSet(0L, Long.MAX_VALUE) ? 0 : this.emitted.intValue();
            long limit = this.count + (long)starting;
            while (limit > 0L) {
                FlowCursorIterator iterator = ts.iterator(starting, limit);
                try {
                    long i = 0L;
                    while (!this.disposable.isDisposed() && iterator.hasNext() && i++ < limit) {
                        this.subscriber.onNext(iterator.next());
                    }
                    this.emitted.addAndGet(i);
                    if (!this.disposable.isDisposed() && i < limit) {
                        this.subscriber.onComplete();
                        break;
                    }
                    limit = this.requested.addAndGet(-limit);
                }
                catch (Exception e) {
                    FlowLog.logError((Throwable)e);
                    this.subscriber.onError((Throwable)e);
                }
                finally {
                    try {
                        iterator.close();
                    }
                    catch (Exception e) {
                        FlowLog.logError((Throwable)e);
                        this.subscriber.onError((Throwable)e);
                    }
                }
            }
        }

        public void onError(Throwable e) {
            this.subscriber.onError(e);
        }
    }
}

