/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method.provider;

import com.raizlabs.android.dbflow.annotation.provider.Notify;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.ContentProviderDefinition;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableEndpointDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.provider.NotifyMethod;
import com.raizlabs.android.dbflow.processor.definition.method.provider.ProviderMethodUtils;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class UpdateMethod
implements MethodDefinition {
    private static final String PARAM_URI = "uri";
    private static final String PARAM_CONTENT_VALUES = "values";
    private final ContentProviderDefinition contentProviderDefinition;
    private final ProcessorManager manager;

    public UpdateMethod(ContentProviderDefinition contentProviderDefinition, ProcessorManager manager) {
        this.contentProviderDefinition = contentProviderDefinition;
        this.manager = manager;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"update").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassNames.URI, PARAM_URI, new Modifier[0]).addParameter((TypeName)ClassNames.CONTENT_VALUES, PARAM_CONTENT_VALUES, new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "selection", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of(String.class), "selectionArgs", new Modifier[0]).returns(TypeName.INT);
        method.beginControlFlow("switch(MATCHER.match($L))", new Object[]{PARAM_URI});
        for (TableEndpointDefinition tableEndpointDefinition : this.contentProviderDefinition.endpointDefinitions) {
            for (ContentUriDefinition uriDefinition : tableEndpointDefinition.contentUriDefinitions) {
                if (!uriDefinition.updateEnabled) continue;
                method.beginControlFlow("case $L:", new Object[]{uriDefinition.name});
                method.addStatement("$T adapter = $T.getModelAdapter($T.getTableClassForName($S, $S))", new Object[]{ClassNames.MODEL_ADAPTER, ClassNames.FLOW_MANAGER, ClassNames.FLOW_MANAGER, this.contentProviderDefinition.databaseNameString, tableEndpointDefinition.tableName});
                method.addCode(ProviderMethodUtils.getSegmentsPreparation(uriDefinition));
                method.addCode("long count = $T.getDatabase($S).getWritableDatabase().updateWithOnConflict($S, $L, ", new Object[]{ClassNames.FLOW_MANAGER, this.manager.getDatabaseName(this.contentProviderDefinition.databaseName), tableEndpointDefinition.tableName, PARAM_CONTENT_VALUES});
                method.addCode(ProviderMethodUtils.getSelectionAndSelectionArgs(uriDefinition));
                method.addCode(", $T.getSQLiteDatabaseAlgorithmInt(adapter.getUpdateOnConflictAction()));\n", new Object[]{ClassNames.CONFLICT_ACTION});
                CodeBlock.Builder code = CodeBlock.builder();
                new NotifyMethod(tableEndpointDefinition, uriDefinition, Notify.Method.UPDATE).addCode(code);
                method.addCode(code.build());
                method.addStatement("return (int) count", new Object[0]);
                method.endControlFlow();
            }
        }
        method.beginControlFlow("default:", new Object[0]).addStatement("throw new $T($S + $L)", new Object[]{ClassName.get(IllegalStateException.class), "Unknown Uri", PARAM_URI}).endControlFlow();
        method.endControlFlow();
        return method.build();
    }
}

